/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.maven.plugin.AbstractWebAppMojo;

@Mojo(name="stop")
public class JettyStopMojo
extends AbstractWebAppMojo {
    @Parameter
    protected int stopWait;

    @Override
    protected void startJettyEmbedded() throws MojoExecutionException {
    }

    @Override
    protected void startJettyForked() throws MojoExecutionException {
    }

    @Override
    protected void startJettyHome() throws MojoExecutionException {
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.stopPort <= 0) {
            throw new MojoExecutionException("Please specify a valid port");
        }
        if (this.stopKey == null) {
            throw new MojoExecutionException("Please specify a valid stopKey");
        }
        String command = "forcestop";
        try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), this.stopPort);){
            OutputStream out = s.getOutputStream();
            out.write((this.stopKey + "\r\n" + command + "\r\n").getBytes());
            out.flush();
            if (this.stopWait > 0) {
                String response;
                s.setSoTimeout(this.stopWait * 1000);
                s.getInputStream();
                this.getLog().info((CharSequence)("Waiting " + this.stopWait + " seconds for jetty to stop"));
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                boolean stopped = false;
                while (!stopped && (response = lin.readLine()) != null) {
                    if (!"Stopped".equals(response)) continue;
                    stopped = true;
                    this.getLog().info((CharSequence)"Server reports itself as stopped");
                }
            }
        }
        catch (ConnectException e) {
            this.getLog().info((CharSequence)"Jetty not running!");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }
}

