/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.eclipse.jetty.maven.plugin.JettyRunMojo;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.PluginLog;
import org.eclipse.jetty.maven.plugin.ServerSupport;
import org.eclipse.jetty.maven.plugin.Starter;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettyRunForkedMojo
extends JettyRunMojo {
    protected File target;
    protected File forkWebXml;
    private String jvmArgs;
    private List pluginArtifacts;
    private PluginDescriptor plugin;
    private boolean waitForChild;
    private int maxStartupLines;
    private Map<String, String> env = new HashMap<String, String>();
    private Process forkedProcess;
    private Random random;
    private Resource originalBaseResource;
    private boolean originalPersistTemp;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.random = new Random();
        super.execute();
    }

    @Override
    public void startJetty() throws MojoExecutionException {
        block38: {
            try {
                String classPath;
                this.printSystemProperties();
                if (this.server == null) {
                    this.server = new Server();
                }
                ServerSupport.configureHandlers(this.server, null);
                ServerSupport.configureDefaultConfigurationClasses(this.server);
                this.configureWebApplication();
                this.originalBaseResource = this.webApp.getBaseResource();
                this.originalPersistTemp = this.webApp.isPersistTempDirectory();
                this.webApp.setCopyWebDir(false);
                this.webApp.setCopyWebInf(false);
                this.webApp.setGenerateQuickStart(true);
                if (this.webApp.getQuickStartWebDescriptor() == null) {
                    if (this.forkWebXml == null) {
                        this.forkWebXml = new File(this.target, "fork-web.xml");
                    }
                    if (!this.forkWebXml.getParentFile().exists()) {
                        this.forkWebXml.getParentFile().mkdirs();
                    }
                    if (!this.forkWebXml.exists()) {
                        this.forkWebXml.createNewFile();
                    }
                    this.webApp.setQuickStartWebDescriptor(Resource.newResource((File)this.forkWebXml));
                }
                ServerSupport.addWebApplication(this.server, this.webApp);
                QueuedThreadPool tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
                if (tpool != null) {
                    tpool.start();
                } else {
                    this.webApp.setAttribute("org.eclipse.jetty.annotations.multiThreaded", Boolean.FALSE.toString());
                }
                this.webApp.setPersistTempDirectory(true);
                this.webApp.start();
                File props = this.prepareConfiguration();
                this.webApp.stop();
                if (tpool != null) {
                    tpool.stop();
                }
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(this.getJavaBin());
                if (this.jvmArgs != null) {
                    String[] args = this.jvmArgs.split(" ");
                    for (int i = 0; args != null && i < args.length; ++i) {
                        if (args[i] == null || "".equals(args[i])) continue;
                        cmd.add(args[i].trim());
                    }
                }
                if ((classPath = this.getContainerClassPath()) != null && classPath.length() > 0) {
                    cmd.add("-cp");
                    cmd.add(classPath);
                }
                cmd.add(Starter.class.getCanonicalName());
                if (this.stopPort > 0 && this.stopKey != null) {
                    cmd.add("--stop-port");
                    cmd.add(Integer.toString(this.stopPort));
                    cmd.add("--stop-key");
                    cmd.add(this.stopKey);
                }
                if (this.jettyXml != null) {
                    cmd.add("--jetty-xml");
                    cmd.add(this.jettyXml);
                }
                if (this.contextXml != null) {
                    cmd.add("--context-xml");
                    cmd.add(this.contextXml);
                }
                cmd.add("--props");
                cmd.add(props.getAbsolutePath());
                String token = this.createToken();
                cmd.add("--token");
                cmd.add(token);
                ProcessBuilder builder = new ProcessBuilder(cmd);
                builder.directory(this.project.getBasedir());
                if (PluginLog.getLog().isDebugEnabled()) {
                    PluginLog.getLog().debug((CharSequence)("Forked cli:" + Arrays.toString(cmd.toArray())));
                }
                PluginLog.getLog().info((CharSequence)"Forked process starting");
                if (!this.env.isEmpty()) {
                    builder.environment().putAll(this.env);
                }
                if (this.waitForChild) {
                    this.forkedProcess = builder.start();
                    this.startPump("STDOUT", this.forkedProcess.getInputStream());
                    this.startPump("STDERR", this.forkedProcess.getErrorStream());
                    int exitcode = this.forkedProcess.waitFor();
                    PluginLog.getLog().info((CharSequence)("Forked execution exit: " + exitcode));
                    break block38;
                }
                builder.redirectErrorStream(true);
                this.forkedProcess = builder.start();
                try {
                    String line = "";
                    try (InputStream is = this.forkedProcess.getInputStream();
                         LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));){
                        for (int attempts = this.maxStartupLines; attempts > 0 && line != null; --attempts) {
                            line = reader.readLine();
                            if (line == null || !line.startsWith(token)) continue;
                            break;
                        }
                    }
                    if (line != null && line.trim().equals(token)) {
                        PluginLog.getLog().info((CharSequence)"Forked process started.");
                    } else {
                        String err = line == null ? "" : (line.startsWith(token) ? line.substring(token.length()) : line);
                        PluginLog.getLog().info((CharSequence)("Forked process startup errors" + (!"".equals(err) ? ", received: " + err : "")));
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Problem determining if forked process is ready: " + e.getMessage());
                }
            }
            catch (InterruptedException ex) {
                if (this.forkedProcess != null && this.waitForChild) {
                    this.forkedProcess.destroy();
                }
                throw new MojoExecutionException("Failed to start Jetty within time limit");
            }
            catch (Exception ex) {
                if (this.forkedProcess != null && this.waitForChild) {
                    this.forkedProcess.destroy();
                }
                throw new MojoExecutionException("Failed to create Jetty process", ex);
            }
        }
    }

    public List<String> getProvidedJars() throws MojoExecutionException {
        if (this.useProvidedScope) {
            ArrayList<String> provided = new ArrayList<String>();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!"provided".equals(artifact.getScope()) || this.isPluginArtifact(artifact)) continue;
                provided.add(artifact.getFile().getAbsolutePath());
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided artifact: " + artifact));
            }
            return provided;
        }
        return null;
    }

    public File prepareConfiguration() throws MojoExecutionException {
        try {
            File propsFile = new File(this.target, "fork.props");
            if (propsFile.exists()) {
                propsFile.delete();
            }
            propsFile.createNewFile();
            Properties props = new Properties();
            if (this.webApp.getDescriptor() != null) {
                props.put("web.xml", this.webApp.getDescriptor());
            }
            if (this.webApp.getQuickStartWebDescriptor() != null) {
                props.put("quickstart.web.xml", this.webApp.getQuickStartWebDescriptor().getFile().getAbsolutePath());
            }
            if (this.webApp.getContextPath() != null) {
                props.put("context.path", this.webApp.getContextPath());
            }
            props.put("tmp.dir", this.webApp.getTempDirectory().getAbsolutePath());
            props.put("tmp.dir.persist", Boolean.toString(this.originalPersistTemp));
            if (this.originalBaseResource instanceof ResourceCollection) {
                props.put("base.dirs.orig", this.toCSV(((ResourceCollection)this.originalBaseResource).getResources()));
            } else {
                props.put("base.dirs.orig", this.originalBaseResource.toString());
            }
            Resource postOverlayResources = (Resource)this.webApp.getAttribute("org.eclipse.jetty.resource.postOverlay");
            if (postOverlayResources instanceof ResourceCollection) {
                props.put("base.dirs", this.toCSV(((ResourceCollection)postOverlayResources).getResources()));
            } else {
                props.put("base.dirs", postOverlayResources.toString());
            }
            if (this.webApp.getClasses() != null) {
                props.put("classes.dir", this.webApp.getClasses().getAbsolutePath());
            }
            if (this.useTestScope && this.webApp.getTestClasses() != null) {
                props.put("testClasses.dir", this.webApp.getTestClasses().getAbsolutePath());
            }
            List<File> deps = this.webApp.getWebInfLib();
            StringBuffer strbuff = new StringBuffer();
            for (int i = 0; i < deps.size(); ++i) {
                File d = deps.get(i);
                strbuff.append(d.getAbsolutePath());
                if (i >= deps.size() - 1) continue;
                strbuff.append(",");
            }
            props.put("lib.jars", strbuff.toString());
            List<Artifact> warArtifacts = this.getWarArtifacts();
            for (int i = 0; i < warArtifacts.size(); ++i) {
                strbuff.setLength(0);
                Artifact a = warArtifacts.get(i);
                strbuff.append(a.getGroupId() + ",");
                strbuff.append(a.getArtifactId() + ",");
                strbuff.append(a.getFile().getAbsolutePath());
                props.put("maven.war.artifact." + i, strbuff.toString());
            }
            WarPluginInfo warPlugin = new WarPluginInfo(this.project);
            props.put("maven.war.includes", this.toCSV(warPlugin.getDependentMavenWarIncludes()));
            props.put("maven.war.excludes", this.toCSV(warPlugin.getDependentMavenWarExcludes()));
            List<OverlayConfig> configs = warPlugin.getMavenWarOverlayConfigs();
            int i = 0;
            for (OverlayConfig c : configs) {
                props.put("maven.war.overlay." + i++, c.toString());
            }
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propsFile));){
                props.store(out, "properties for forked webapp");
            }
            return propsFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Prepare webapp configuration", e);
        }
    }

    private List<Artifact> getWarArtifacts() throws MalformedURLException, IOException {
        ArrayList<Artifact> warArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getType().equals("war")) continue;
            warArtifacts.add(artifact);
        }
        return warArtifacts;
    }

    @Override
    public boolean isPluginArtifact(Artifact artifact) {
        if (this.pluginArtifacts == null || this.pluginArtifacts.isEmpty()) {
            return false;
        }
        boolean isPluginArtifact = false;
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext() && !isPluginArtifact) {
            Artifact pluginArtifact = (Artifact)iter.next();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking " + pluginArtifact));
            }
            if (!pluginArtifact.getGroupId().equals(artifact.getGroupId()) || !pluginArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            isPluginArtifact = true;
        }
        return isPluginArtifact;
    }

    private Set<Artifact> getExtraJars() throws Exception {
        HashSet<Artifact> extraJars = new HashSet<Artifact>();
        List l = this.pluginArtifacts;
        Object pluginArtifact = null;
        if (l != null) {
            Iterator itor = l.iterator();
            while (itor.hasNext() && pluginArtifact == null) {
                Artifact a = (Artifact)itor.next();
                if (!a.getArtifactId().equals(this.plugin.getArtifactId())) continue;
                extraJars.add(a);
            }
        }
        return extraJars;
    }

    public String getContainerClassPath() throws Exception {
        StringBuilder classPath = new StringBuilder();
        for (Object obj : this.pluginArtifacts) {
            Artifact artifact = (Artifact)obj;
            if (!"jar".equals(artifact.getType())) continue;
            if (classPath.length() > 0) {
                classPath.append(File.pathSeparator);
            }
            classPath.append(artifact.getFile().getAbsolutePath());
        }
        Set<Artifact> extraJars = this.getExtraJars();
        for (Artifact a : extraJars) {
            classPath.append(File.pathSeparator);
            classPath.append(a.getFile().getAbsolutePath());
        }
        List<String> providedJars = this.getProvidedJars();
        if (providedJars != null && !providedJars.isEmpty()) {
            for (String jar : providedJars) {
                classPath.append(File.pathSeparator);
                classPath.append(jar);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Adding provided jar: " + jar));
            }
        }
        return classPath.toString();
    }

    private String getJavaBin() {
        String[] javaexes = new String[]{"java", "java.exe"};
        File javaHomeDir = new File(System.getProperty("java.home"));
        for (String javaexe : javaexes) {
            File javabin = new File(javaHomeDir, JettyRunForkedMojo.fileSeparators("bin/" + javaexe));
            if (!javabin.exists() || !javabin.isFile()) continue;
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String fileSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String pathSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == ',' || c == ':') {
                ret.append(File.pathSeparatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    private String createToken() {
        return Long.toString(this.random.nextLong() ^ System.currentTimeMillis(), 36).toUpperCase(Locale.ENGLISH);
    }

    private void startPump(String mode, InputStream inputStream) {
        ConsoleStreamer pump = new ConsoleStreamer(mode, inputStream);
        Thread thread = new Thread((Runnable)pump, "ConsoleStreamer/" + mode);
        thread.setDaemon(true);
        thread.start();
    }

    private String toCSV(List<String> strings) {
        if (strings == null) {
            return "";
        }
        StringBuffer strbuff = new StringBuffer();
        Iterator<String> itor = strings.iterator();
        while (itor.hasNext()) {
            strbuff.append(itor.next());
            if (!itor.hasNext()) continue;
            strbuff.append(",");
        }
        return strbuff.toString();
    }

    private String toCSV(Resource[] resources) {
        StringBuffer rb = new StringBuffer();
        for (Resource r : resources) {
            if (rb.length() > 0) {
                rb.append(",");
            }
            rb.append(r.toString());
        }
        return rb.toString();
    }

    private static class ConsoleStreamer
    implements Runnable {
        private String mode;
        private BufferedReader reader;

        public ConsoleStreamer(String mode, InputStream is) {
            this.mode = mode;
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    System.out.println("[" + this.mode + "] " + line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                IO.close((Reader)this.reader);
            }
        }
    }

    public class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            super("RunForkedShutdown");
        }

        @Override
        public void run() {
            if (JettyRunForkedMojo.this.forkedProcess != null && JettyRunForkedMojo.this.waitForChild) {
                JettyRunForkedMojo.this.forkedProcess.destroy();
            }
        }
    }
}

