/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class NoSqlSessionManager
extends AbstractSessionManager
implements SessionManager {
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    protected final ConcurrentMap<String, NoSqlSession> _sessions = new ConcurrentHashMap<String, NoSqlSession>();
    private int _stalePeriod = 0;
    private int _savePeriod = 0;
    private int _idlePeriod = -1;
    private boolean _invalidateOnStop;
    private boolean _preserveOnStop = true;
    private boolean _saveAllAttributes;

    public void doStart() throws Exception {
        super.doStart();
    }

    protected void addSession(AbstractSession session) {
        if (this.isRunning()) {
            this._sessions.put(session.getClusterId(), (NoSqlSession)session);
            ((NoSqlSession)session).save(true);
        }
    }

    public AbstractSession getSession(String idInCluster) {
        NoSqlSession session = (NoSqlSession)((Object)this._sessions.get(idInCluster));
        __log.debug("getSession {} ", new Object[]{session});
        if (session == null) {
            session = this.loadSession(idInCluster);
            if (session != null) {
                NoSqlSession race = this._sessions.putIfAbsent(idInCluster, session);
                if (race != null) {
                    session.willPassivate();
                    session.clearAttributes();
                    session = race;
                } else {
                    __log.debug("session loaded ", new Object[]{idInCluster});
                }
                if (this.getMaxInactiveInterval() > 0 && session.getAccessed() > 0L && (long)(this.getMaxInactiveInterval() * 1000) + session.getAccessed() < System.currentTimeMillis()) {
                    __log.debug("session expired ", new Object[]{idInCluster});
                    this.expire(idInCluster);
                    session = null;
                }
            } else {
                __log.debug("session does not exist {}", new Object[]{idInCluster});
            }
        }
        return session;
    }

    protected void shutdownSessions() throws Exception {
        long gracefulStopMs = this.getContextHandler().getServer().getStopTimeout();
        long stopTime = 0L;
        if (gracefulStopMs > 0L) {
            stopTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(gracefulStopMs, TimeUnit.MILLISECONDS);
        }
        ArrayList sessions = new ArrayList(this._sessions.values());
        while (sessions.size() > 0 && (stopTime > 0L && System.nanoTime() < stopTime || stopTime == 0L)) {
            for (NoSqlSession session : sessions) {
                if (this.isPreserveOnStop()) {
                    session.save(false);
                    this._sessions.remove(session.getClusterId());
                    continue;
                }
                session.invalidate();
            }
            if (stopTime == 0L) break;
            sessions = new ArrayList(this._sessions.values());
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new NoSqlSession(this, request);
    }

    protected boolean removeSession(String idInCluster) {
        NoSqlSession session = (NoSqlSession)((Object)this._sessions.remove(idInCluster));
        try {
            if (session != null) {
                return this.remove(session);
            }
        }
        catch (Exception e) {
            __log.warn("Problem deleting session {}", new Object[]{idInCluster, e});
        }
        return session != null;
    }

    protected void expire(String idInCluster) {
        NoSqlSession session = (NoSqlSession)((Object)this._sessions.get(idInCluster));
        try {
            if (session == null) {
                session = this.loadSession(idInCluster);
            }
            if (session != null) {
                session.timeout();
            }
        }
        catch (Exception e) {
            __log.warn("Problem expiring session {}", new Object[]{idInCluster, e});
        }
    }

    public void invalidateSession(String idInCluster) {
        NoSqlSession session = (NoSqlSession)((Object)this._sessions.get(idInCluster));
        try {
            __log.debug("invalidating session {}", new Object[]{idInCluster});
            if (session != null) {
                session.invalidate();
            }
        }
        catch (Exception e) {
            __log.warn("Problem invalidating session {}", new Object[]{idInCluster, e});
        }
    }

    public int getStalePeriod() {
        return this._stalePeriod;
    }

    public void setStalePeriod(int stalePeriod) {
        this._stalePeriod = stalePeriod;
    }

    public int getSavePeriod() {
        return this._savePeriod;
    }

    public void setSavePeriod(int savePeriod) {
        this._savePeriod = savePeriod;
    }

    public int getIdlePeriod() {
        return this._idlePeriod;
    }

    public void setIdlePeriod(int idlePeriod) {
        this._idlePeriod = idlePeriod;
    }

    public boolean isInvalidateOnStop() {
        return this._invalidateOnStop;
    }

    public boolean isPreserveOnStop() {
        return this._preserveOnStop;
    }

    public void setInvalidateOnStop(boolean invalidateOnStop) {
        this._invalidateOnStop = invalidateOnStop;
    }

    public void setPreserveOnStop(boolean preserveOnStop) {
        this._preserveOnStop = preserveOnStop;
    }

    public boolean isSaveAllAttributes() {
        return this._saveAllAttributes;
    }

    public void setSaveAllAttributes(boolean saveAllAttributes) {
        this._saveAllAttributes = saveAllAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        NoSqlSessionManager noSqlSessionManager = this;
        synchronized (noSqlSessionManager) {
            try {
                NoSqlSession session = (NoSqlSession)((Object)this._sessions.remove(oldClusterId));
                this.update(session, newClusterId, newNodeId);
                session.setClusterId(newClusterId);
                session.setNodeId(newNodeId);
                this._sessions.put(newClusterId, session);
            }
            catch (Exception e) {
                __log.warn((Throwable)e);
            }
        }
        super.renewSessionId(oldClusterId, oldNodeId, newClusterId, newNodeId);
    }

    protected abstract NoSqlSession loadSession(String var1);

    protected abstract Object save(NoSqlSession var1, Object var2, boolean var3);

    protected abstract Object refresh(NoSqlSession var1, Object var2);

    protected abstract boolean remove(NoSqlSession var1);

    protected abstract void update(NoSqlSession var1, String var2, String var3) throws Exception;
}

