/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.MemSession;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NoSqlSession
extends MemSession {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private final NoSqlSessionManager _manager;
    private Set<String> _dirty;
    private final AtomicInteger _active = new AtomicInteger();
    private Object _version;
    private long _lastSync;
    private IdleState _idle = IdleState.NOT_IDLE;
    private boolean _deIdleFailed;

    public NoSqlSession(NoSqlSessionManager manager, HttpServletRequest request) {
        super((AbstractSessionManager)manager, request);
        this._manager = manager;
        this._active.incrementAndGet();
    }

    public NoSqlSession(NoSqlSessionManager manager, long created, long accessed, String clusterId, Object version) {
        super((AbstractSessionManager)manager, created, accessed, clusterId);
        this._manager = manager;
        this._version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doPutOrRemove(String name, Object value) {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            Object old = super.doPutOrRemove(name, value);
            if (this._manager.getSavePeriod() == -2) {
                this.save(true);
            }
            return old;
        }
    }

    public void setAttribute(String name, Object value) {
        Object old = this.changeAttribute(name, value);
        if (value == null && old == null) {
            return;
        }
        if (value == null || !value.equals(old)) {
            if (this._dirty == null) {
                this._dirty = new HashSet<String>();
            }
            this._dirty.add(name);
        }
    }

    protected void timeout() throws IllegalStateException {
        super.timeout();
    }

    protected void checkValid() throws IllegalStateException {
        if (!this.isDeIdleFailed() && this._manager.getIdlePeriod() > 0 && this.isIdle()) {
            this.deIdle();
        }
        try {
            super.checkValid();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e.getMessage() + " idle=" + (Object)((Object)this._idle) + " deidleFailed=" + this._deIdleFailed + " version=" + this._version, e);
        }
    }

    protected boolean access(long time) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("NoSqlSession:access:active {} time {}", new Object[]{this._active, time});
        }
        if (this._active.incrementAndGet() == 1) {
            long period = (long)this._manager.getStalePeriod() * 1000L;
            if (period == 0L) {
                this.refresh();
            } else if (period > 0L) {
                long stale = time - this._lastSync;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NoSqlSession:access:stale " + stale, new Object[0]);
                }
                if (stale > period) {
                    this.refresh();
                }
            }
        }
        return super.access(time);
    }

    protected void complete() {
        super.complete();
        if (this._active.decrementAndGet() == 0) {
            switch (this._manager.getSavePeriod()) {
                case 0: {
                    this.save(this.isValid());
                    break;
                }
                case 1: {
                    if (!this.isDirty()) break;
                    this.save(this.isValid());
                }
            }
        }
    }

    protected void doInvalidate() throws IllegalStateException {
        super.doInvalidate();
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(boolean activateAfterSave) {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            this._version = this._manager.save(this, this._version, activateAfterSave);
            this._lastSync = this.getAccessed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            if (!this.isIdle() && !this.isIdling()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Idling {}", new Object[]{super.getId()});
                }
                this.setIdling();
                this.save(false);
                this.willPassivate();
                this.clearAttributes();
                this.setIdle(true);
            }
        }
    }

    public synchronized void deIdle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking before de-idling {}, isidle:{}, isDeidleFailed:", new Object[]{super.getId(), this.isIdle(), this.isDeIdleFailed()});
        }
        if (this.isIdle() && !this.isDeIdleFailed()) {
            this.setDeIdling();
            if (LOG.isDebugEnabled()) {
                LOG.debug("De-idling " + super.getId(), new Object[0]);
            }
            super.access(System.currentTimeMillis());
            if (this.isValid()) {
                try {
                    this.setIdle(false);
                    this._version = this._manager.refresh(this, new Long(0L));
                    if (this._version == null) {
                        this.setDeIdleFailed(true);
                    }
                }
                catch (Exception e) {
                    this.setDeIdleFailed(true);
                    LOG.warn("Problem de-idling session " + super.getId(), (Throwable)e);
                    this.invalidate();
                }
            }
        }
    }

    public synchronized boolean isIdle() {
        return this._idle == IdleState.IDLE;
    }

    public synchronized boolean isIdling() {
        return this._idle == IdleState.IDLING;
    }

    public synchronized boolean isDeIdling() {
        return this._idle == IdleState.DEIDLING;
    }

    public synchronized void setIdling() {
        this._idle = IdleState.IDLING;
    }

    public synchronized void setDeIdling() {
        this._idle = IdleState.DEIDLING;
    }

    public synchronized void setIdle(boolean idle) {
        this._idle = idle ? IdleState.IDLE : IdleState.NOT_IDLE;
    }

    public boolean isDeIdleFailed() {
        return this._deIdleFailed;
    }

    public void setDeIdleFailed(boolean _deIdleFailed) {
        this._deIdleFailed = _deIdleFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            this._version = this._manager.refresh(this, this._version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            return this._dirty != null && !this._dirty.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> takeDirty() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            Set<String> dirty = this._dirty;
            if (dirty == null) {
                dirty = new HashSet<String>();
            } else {
                this._dirty = null;
            }
            return dirty;
        }
    }

    public Object getVersion() {
        return this._version;
    }

    public void setClusterId(String clusterId) {
        super.setClusterId(clusterId);
    }

    public void setNodeId(String nodeId) {
        super.setNodeId(nodeId);
    }

    private static enum IdleState {
        NOT_IDLE,
        IDLE,
        IDLING,
        DEIDLING;

    }
}

