/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContextProvider
extends AbstractLifeCycle
implements AppProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContextProvider.class);
    private DeploymentManager _deploymentManager;
    private Server _server;
    private ContextFactory _contextFactory;
    private String _environment;
    private final Map<String, String> _properties = new HashMap<String, String>();

    public AbstractContextProvider(String environment, Server server, ContextFactory contextFactory) {
        this._environment = Objects.requireNonNull(environment);
        this._server = Objects.requireNonNull(server);
        this._contextFactory = Objects.requireNonNull(contextFactory);
    }

    public Server getServer() {
        return this._server;
    }

    public Map<String, String> getProperties() {
        return this._properties;
    }

    public ContextHandler createContextHandler(App app) throws Exception {
        if (app == null) {
            return null;
        }
        ContextHandler h = this._contextFactory.createContextHandler(this, app);
        return h;
    }

    public void setDeploymentManager(DeploymentManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public String getEnvironmentName() {
        return this._environment;
    }

    public DeploymentManager getDeploymentManager() {
        return this._deploymentManager;
    }

    public boolean isExtractWars() {
        return Boolean.parseBoolean(this._properties.get("jetty.deploy.extractWars"));
    }

    public void setExtractWars(boolean extractWars) {
        this._properties.put("jetty.deploy.extractWars", Boolean.toString(extractWars));
    }

    public boolean isParentLoaderPriority() {
        return Boolean.parseBoolean(this._properties.get("jetty.deploy.parentLoaderPriority"));
    }

    public void setParentLoaderPriority(boolean parentLoaderPriority) {
        this._properties.put("jetty.deploy.parentLoaderPriority", Boolean.toString(parentLoaderPriority));
    }

    public String getDefaultsDescriptor() {
        return this._properties.get("jetty.deploy.defaultsDescriptor");
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._properties.put("jetty.deploy.defaultsDescriptor", defaultsDescriptor);
    }

    public void setConfigurationClasses(String configurations) {
        this.setConfigurationClasses(StringUtil.isBlank((String)configurations) ? null : configurations.split(","));
    }

    public void setConfigurationClasses(String[] configurations) {
        this._properties.put("jetty.deploy.configurationClasses", configurations == null ? null : String.join((CharSequence)",", configurations));
    }

    public String[] getConfigurationClasses() {
        String cc = this._properties.get("jetty.deploy.configurationClasses");
        return cc == null ? new String[]{} : cc.split(",");
    }

    public void setTldBundles(String tldBundles) {
        this._properties.put("Require-TldBundle", tldBundles);
    }

    public String getTldBundles() {
        return this._properties.get("Require-TldBundle");
    }

    public boolean isDeployable(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        return this.getEnvironmentName().equalsIgnoreCase((String)bundle.getHeaders().get("Jetty-Environment"));
    }

    public boolean isDeployable(ServiceReference service) {
        if (service == null) {
            return false;
        }
        if (!StringUtil.isBlank((String)((String)service.getProperty("o.e.j.o.b.watermark")))) {
            return false;
        }
        return this.getEnvironmentName().equalsIgnoreCase((String)service.getProperty("Jetty-Environment"));
    }
}

