/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.jaas.JAASUserPrincipal;
import org.eclipse.jetty.jaas.PropertyUserStoreManager;
import org.eclipse.jetty.jaas.callback.DefaultCallbackHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = LoggerFactory.getLogger(JAASLoginService.class);
    public static final String DEFAULT_ROLE_CLASS_NAME = "org.eclipse.jetty.jaas.JAASRole";
    public static final String[] DEFAULT_ROLE_CLASS_NAMES = new String[]{"org.eclipse.jetty.jaas.JAASRole"};
    public static final ThreadLocal<JAASLoginService> INSTANCE = new ThreadLocal();
    protected String[] _roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
    protected String _callbackHandlerClass;
    protected String _realmName;
    protected String _loginModuleName;
    protected JAASUserPrincipal _defaultUser = new JAASUserPrincipal(null, null, null);
    protected IdentityService _identityService;
    protected Configuration _configuration;

    public JAASLoginService() {
    }

    public JAASLoginService(String name) {
        this();
        this._realmName = name;
        this._loginModuleName = name;
    }

    @Override
    public String getName() {
        return this._realmName;
    }

    public void setName(String name) {
        this._realmName = name;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    @Override
    public void setIdentityService(IdentityService identityService) {
        this._identityService = identityService;
    }

    public void setLoginModuleName(String name) {
        this._loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this._callbackHandlerClass = classname;
    }

    public void setRoleClassNames(String[] classnames) {
        if (classnames == null || classnames.length == 0) {
            this._roleClassNames = DEFAULT_ROLE_CLASS_NAMES;
            return;
        }
        this._roleClassNames = ArrayUtil.addToArray(classnames, DEFAULT_ROLE_CLASS_NAME, String.class);
    }

    public String[] getRoleClassNames() {
        return this._roleClassNames;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._identityService == null) {
            this._identityService = new DefaultIdentityService();
        }
        this.addBean(new PropertyUserStoreManager());
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        try {
            CallbackHandler callbackHandler = null;
            if (this._callbackHandlerClass == null) {
                callbackHandler = new DefaultCallbackHandler();
            } else {
                Class clazz = Loader.loadClass(this._callbackHandlerClass);
                callbackHandler = (CallbackHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (callbackHandler instanceof DefaultCallbackHandler) {
                DefaultCallbackHandler dch = callbackHandler;
                if (request instanceof Request) {
                    dch.setRequest((Request)request);
                }
                dch.setCredential(credentials);
                dch.setUserName(username);
            }
            Subject subject = new Subject();
            INSTANCE.set(this);
            LoginContext loginContext = this._configuration == null ? new LoginContext(this._loginModuleName, subject, callbackHandler) : new LoginContext(this._loginModuleName, subject, callbackHandler, this._configuration);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(this.getUserName(callbackHandler), subject, loginContext);
            subject.getPrincipals().add(userPrincipal);
            UserIdentity userIdentity = this._identityService.newUserIdentity(subject, userPrincipal, this.getGroups(subject));
            return userIdentity;
        }
        catch (FailedLoginException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Login failed", e);
            }
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Login error", e);
            }
        }
        finally {
            INSTANCE.remove();
        }
        return null;
    }

    @Override
    public boolean validate(UserIdentity user) {
        return true;
    }

    private String getUserName(CallbackHandler callbackHandler) throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("foo");
        callbackHandler.handle(new Callback[]{nameCallback});
        return nameCallback.getName();
    }

    @Override
    public void logout(UserIdentity user) {
        Set<JAASUserPrincipal> userPrincipals = user.getSubject().getPrincipals(JAASUserPrincipal.class);
        LoginContext loginContext = userPrincipals.iterator().next().getLoginContext();
        try {
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.warn("Failed to logout {}", (Object)user, (Object)e);
        }
    }

    protected String[] getGroups(Subject subject) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (Principal principal : subject.getPrincipals()) {
            if (!JAASLoginService.isRoleClass(principal.getClass(), Arrays.asList(this.getRoleClassNames()))) continue;
            groups.add(principal.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    private static boolean isRoleClass(Class<?> clazz, List<String> roleClassNames) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            classnames.add(c.getName());
            Arrays.stream(c.getInterfaces()).map(Class::getName).forEach(classnames::add);
        }
        return roleClassNames.stream().anyMatch(classnames::contains);
    }
}

