/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private final WebSocketServletFactory webSocketFactory;

    public WebSocketHandler() {
        this(new MappedByteBufferPool());
    }

    public WebSocketHandler(ByteBufferPool bufferPool) {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.configurePolicy(policy);
        this.webSocketFactory = new WebSocketServerFactory(policy, bufferPool);
        this.addBean(this.webSocketFactory);
    }

    public abstract void configure(WebSocketServletFactory var1);

    public void configurePolicy(WebSocketPolicy policy) {
    }

    @Override
    protected void doStart() throws Exception {
        this.configure(this.webSocketFactory);
        super.doStart();
    }

    public WebSocketServletFactory getWebSocketFactory() {
        return this.webSocketFactory;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.webSocketFactory.isUpgradeRequest(request, response)) {
            if (this.webSocketFactory.acceptWebSocket(request, response)) {
                baseRequest.setHandled(true);
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    public static class Simple
    extends WebSocketHandler {
        private Class<?> websocketPojo;

        public Simple(Class<?> websocketClass) {
            this.websocketPojo = websocketClass;
        }

        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(this.websocketPojo);
        }
    }
}

