/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.jstl.tlv.PageParser;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFreeTLV
extends TagLibraryValidator {
    private static final PageParser parser = new PageParser(true);
    private boolean allowDeclarations = false;
    private boolean allowScriptlets = false;
    private boolean allowExpressions = false;
    private boolean allowRTExpressions = false;

    @Override
    public void setInitParameters(Map<String, Object> initParms) {
        super.setInitParameters(initParms);
        String declarationsParm = (String)initParms.get("allowDeclarations");
        String scriptletsParm = (String)initParms.get("allowScriptlets");
        String expressionsParm = (String)initParms.get("allowExpressions");
        String rtExpressionsParm = (String)initParms.get("allowRTExpressions");
        this.allowDeclarations = "true".equalsIgnoreCase(declarationsParm);
        this.allowScriptlets = "true".equalsIgnoreCase(scriptletsParm);
        this.allowExpressions = "true".equalsIgnoreCase(expressionsParm);
        this.allowRTExpressions = "true".equalsIgnoreCase(rtExpressionsParm);
    }

    @Override
    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        try {
            MyContentHandler handler = new MyContentHandler();
            parser.parse(page, handler);
            return handler.reportResults();
        }
        catch (ParserConfigurationException e) {
            return ScriptFreeTLV.vmFromString(e.toString());
        }
        catch (SAXException e) {
            return ScriptFreeTLV.vmFromString(e.toString());
        }
        catch (IOException e) {
            return ScriptFreeTLV.vmFromString(e.toString());
        }
    }

    private static ValidationMessage[] vmFromString(String message) {
        return new ValidationMessage[]{new ValidationMessage(null, message)};
    }

    private class MyContentHandler
    extends DefaultHandler {
        private int declarationCount = 0;
        private int scriptletCount = 0;
        private int expressionCount = 0;
        private int rtExpressionCount = 0;

        private MyContentHandler() {
        }

        public void startElement(String namespaceUri, String localName, String qualifiedName, Attributes atts) {
            if (!ScriptFreeTLV.this.allowDeclarations && qualifiedName.equals("jsp:declaration")) {
                ++this.declarationCount;
            } else if (!ScriptFreeTLV.this.allowScriptlets && qualifiedName.equals("jsp:scriptlet")) {
                ++this.scriptletCount;
            } else if (!ScriptFreeTLV.this.allowExpressions && qualifiedName.equals("jsp:expression")) {
                ++this.expressionCount;
            }
            if (!ScriptFreeTLV.this.allowRTExpressions) {
                this.countRTExpressions(atts);
            }
        }

        private void countRTExpressions(Attributes atts) {
            int stop = atts.getLength();
            for (int i2 = 0; i2 < stop; ++i2) {
                String attval = atts.getValue(i2);
                if (!attval.startsWith("%=") || !attval.endsWith("%")) continue;
                ++this.rtExpressionCount;
            }
        }

        public ValidationMessage[] reportResults() {
            if (this.declarationCount + this.scriptletCount + this.expressionCount + this.rtExpressionCount > 0) {
                StringBuilder results = new StringBuilder("JSP page contains ");
                boolean first = true;
                if (this.declarationCount > 0) {
                    results.append(Integer.toString(this.declarationCount));
                    results.append(" declaration");
                    if (this.declarationCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                if (this.scriptletCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.scriptletCount));
                    results.append(" scriptlet");
                    if (this.scriptletCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                if (this.expressionCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.expressionCount));
                    results.append(" expression");
                    if (this.expressionCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                if (this.rtExpressionCount > 0) {
                    if (!first) {
                        results.append(", ");
                    }
                    results.append(Integer.toString(this.rtExpressionCount));
                    results.append(" request-time attribute value");
                    if (this.rtExpressionCount > 1) {
                        results.append('s');
                    }
                    first = false;
                }
                results.append(".");
                return ScriptFreeTLV.vmFromString(results.toString());
            }
            return null;
        }
    }
}

