/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Optional;
import org.junit.jupiter.api.TestInstance;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

final class TestInstanceLifecycleUtils {
    private static final Logger logger = LoggerFactory.getLogger(TestInstanceLifecycleUtils.class);

    private TestInstanceLifecycleUtils() {
    }

    static TestInstance.Lifecycle getTestInstanceLifecycle(Class<?> testClass, ConfigurationParameters configParams) {
        Preconditions.notNull(testClass, "testClass must not be null");
        Preconditions.notNull(configParams, "ConfigurationParameters must not be null");
        return AnnotationUtils.findAnnotation(testClass, TestInstance.class).map(TestInstance::value).orElseGet(() -> TestInstanceLifecycleUtils.getDefaultTestInstanceLifecycle(configParams));
    }

    static TestInstance.Lifecycle getDefaultTestInstanceLifecycle(ConfigurationParameters configParams) {
        Preconditions.notNull(configParams, "ConfigurationParameters must not be null");
        String propertyName = "junit.jupiter.testinstance.lifecycle.default";
        Optional<String> optional = configParams.get(propertyName);
        String constantName = null;
        if (optional.isPresent()) {
            try {
                constantName = optional.get().trim().toUpperCase();
                TestInstance.Lifecycle lifecycle = TestInstance.Lifecycle.valueOf(constantName);
                logger.info(() -> String.format("Using default test instance lifecycle mode '%s' set via the '%s' configuration parameter.", new Object[]{lifecycle, propertyName}));
                return lifecycle;
            }
            catch (Exception ex) {
                String constant = constantName;
                logger.warn(() -> String.format("Invalid test instance lifecycle mode '%s' set via the '%s' configuration parameter. Falling back to %s lifecycle semantics.", constant, propertyName, TestInstance.Lifecycle.PER_METHOD.name()));
            }
        }
        return TestInstance.Lifecycle.PER_METHOD;
    }
}

