/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi.local;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.eclipse.jetty.jndi.BindingEnumeration;
import org.eclipse.jetty.jndi.NameEnumeration;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.util.log.Logger;

public class localContextRoot
implements Context {
    private static final Logger __log = NamingUtil.__log;
    protected static final NamingContext __root = new NamingRoot();
    private final Hashtable<String, Object> _env;

    public static NamingContext getRoot() {
        return __root;
    }

    public localContextRoot(Hashtable env) {
        this._env = new Hashtable(env);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            __root.destroySubcontext(this.getSuffix(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            this.destroySubcontext(__root.getNameParser("").parse(this.getSuffix(name)));
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            if (name.size() == 0) {
                return;
            }
            if (__root.isLocked()) {
                throw new NamingException("This context is immutable");
            }
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                throw new NamingException("Name is null");
            }
            if (cname.size() == 0) {
                throw new NamingException("Name is empty");
            }
            if (cname.size() == 1) {
                __root.removeBinding(cname);
            } else {
                if (__log.isDebugEnabled()) {
                    __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
                }
                String firstComponent = cname.get(0);
                Object ctx = null;
                if (firstComponent.equals("")) {
                    ctx = this;
                } else {
                    Binding binding = __root.getBinding(name.get(0));
                    if (binding == null) {
                        throw new NameNotFoundException(name.get(0) + " is not bound");
                    }
                    ctx = binding.getObject();
                    if (ctx instanceof Reference) {
                        try {
                            ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                        }
                        catch (NamingException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            __log.warn("", e);
                            throw new NamingException(e.getMessage());
                        }
                    }
                }
                if (ctx instanceof Context) {
                    ((Context)ctx).unbind(cname.getSuffix(1));
                } else {
                    throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
                }
            }
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(__root.getNameParser("").parse(this.getSuffix(name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            return this.lookupLink(__root.getNameParser("").parse(this.getSuffix(name)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                NamingContext ctx = new NamingContext(this._env, null, null, __root.getNameParser(""));
                ctx.setBindings(__root.getBindings());
                return ctx;
            }
            if (cname.size() == 0) {
                throw new NamingException("Name is empty");
            }
            if (cname.size() == 1) {
                Binding binding = __root.getBinding(cname);
                if (binding == null) {
                    throw new NameNotFoundException();
                }
                Object o = binding.getObject();
                if (o instanceof Reference) {
                    try {
                        return NamingManager.getObjectInstance(o, cname.getPrefix(1), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
                return o;
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = __root.getBinding(firstComponent);
                if (binding == null) {
                    throw new NameNotFoundException();
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (!(ctx instanceof Context)) {
                throw new NotContextException();
            }
            return ((Context)ctx).lookup(cname.getSuffix(1));
        }
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._env.remove(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            Name cname;
            if (__log.isDebugEnabled()) {
                __log.debug("Looking up name=\"" + name + "\"", new Object[0]);
            }
            if ((cname = __root.toCanonicalName(name)) == null || cname.size() == 0) {
                __log.debug("Null or empty name, returning copy of this context", new Object[0]);
                NamingContext ctx = new NamingContext(this._env, null, null, __root.getNameParser(""));
                ctx.setBindings(__root.getBindings());
                return ctx;
            }
            if (cname.size() == 1) {
                Binding binding = __root.getBinding(cname);
                if (binding == null) {
                    NameNotFoundException nnfe = new NameNotFoundException();
                    nnfe.setRemainingName(cname);
                    throw nnfe;
                }
                Object o = binding.getObject();
                if (o instanceof LinkRef) {
                    String linkName = ((LinkRef)o).getLinkName();
                    if (linkName.startsWith("./")) {
                        return this.lookup(linkName.substring(2));
                    }
                    InitialContext ictx = new InitialContext();
                    return ictx.lookup(linkName);
                }
                if (o instanceof Reference) {
                    try {
                        return NamingManager.getObjectInstance(o, cname, __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new NamingException(e.getMessage()){
                            {
                                super(arg0);
                                this.initCause(e);
                            }
                        };
                    }
                }
                return o;
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = __root.getBinding(firstComponent);
                if (binding == null) {
                    NameNotFoundException nnfe = new NameNotFoundException();
                    nnfe.setRemainingName(cname);
                    throw nnfe;
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (!(ctx instanceof Context)) {
                throw new NotContextException();
            }
            return ((Context)ctx).lookup(cname.getSuffix(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            return this.lookup(__root.getNameParser("").parse(this.getSuffix(name)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Object obj) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            this.bind(__root.getNameParser("").parse(this.getSuffix(name)), obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object obj) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            if (__root.isLocked()) {
                throw new NamingException("This context is immutable");
            }
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                throw new NamingException("Name is null");
            }
            if (cname.size() == 0) {
                throw new NamingException("Name is empty");
            }
            if (cname.size() == 1) {
                Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
                if (objToBind instanceof Referenceable) {
                    objToBind = ((Referenceable)objToBind).getReference();
                }
                __root.addBinding(cname, objToBind);
            } else {
                if (__log.isDebugEnabled()) {
                    __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
                }
                String firstComponent = cname.get(0);
                Object ctx = null;
                if (firstComponent.equals("")) {
                    ctx = this;
                } else {
                    Binding binding = __root.getBinding(firstComponent);
                    if (binding == null) {
                        throw new NameNotFoundException(firstComponent + " is not bound");
                    }
                    ctx = binding.getObject();
                    if (ctx instanceof Reference) {
                        try {
                            ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), this, this._env);
                        }
                        catch (NamingException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            __log.warn("", e);
                            throw new NamingException(e.getMessage());
                        }
                    }
                }
                if (ctx instanceof Context) {
                    ((Context)ctx).bind(cname.getSuffix(1), obj);
                } else {
                    throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            if (__root.isLocked()) {
                throw new NamingException("This context is immutable");
            }
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                throw new NamingException("Name is null");
            }
            if (cname.size() == 0) {
                throw new NamingException("Name is empty");
            }
            if (cname.size() == 1) {
                Object objToBind = NamingManager.getStateToBind(obj, name, __root, this._env);
                if (objToBind instanceof Referenceable) {
                    objToBind = ((Referenceable)objToBind).getReference();
                }
                __root.removeBinding(cname);
                __root.addBinding(cname, objToBind);
            } else {
                if (__log.isDebugEnabled()) {
                    __log.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
                }
                String firstComponent = cname.get(0);
                Object ctx = null;
                if (firstComponent.equals("")) {
                    ctx = this;
                } else {
                    Binding binding = __root.getBinding(name.get(0));
                    if (binding == null) {
                        throw new NameNotFoundException(name.get(0) + " is not bound");
                    }
                    ctx = binding.getObject();
                    if (ctx instanceof Reference) {
                        try {
                            ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                        }
                        catch (NamingException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            __log.warn("", e);
                            throw new NamingException(e.getMessage());
                        }
                    }
                }
                if (ctx instanceof Context) {
                    ((Context)ctx).rebind(cname.getSuffix(1), obj);
                } else {
                    throw new NotContextException("Object bound at " + firstComponent + " is not a Context");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            this.rebind(__root.getNameParser("").parse(this.getSuffix(name)), obj);
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            throw new OperationNotSupportedException();
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            throw new OperationNotSupportedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            return this.createSubcontext(__root.getNameParser("").parse(name));
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            if (__root.isLocked()) {
                NamingException ne = new NamingException("This context is immutable");
                ne.setRemainingName(name);
                throw ne;
            }
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                throw new NamingException("Name is null");
            }
            if (cname.size() == 0) {
                throw new NamingException("Name is empty");
            }
            if (cname.size() == 1) {
                Binding binding = __root.getBinding(cname);
                if (binding != null) {
                    throw new NameAlreadyBoundException(cname.toString());
                }
                NamingContext ctx = new NamingContext((Hashtable)this._env.clone(), cname.get(0), __root, __root.getNameParser(""));
                __root.addBinding(cname, ctx);
                return ctx;
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = __root.getBinding(firstComponent);
                if (binding == null) {
                    throw new NameNotFoundException(firstComponent + " is not bound");
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    if (__log.isDebugEnabled()) {
                        __log.debug("Object bound at " + firstComponent + " is a Reference", new Object[0]);
                    }
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (ctx instanceof Context) {
                return ((Context)ctx).createSubcontext(cname.getSuffix(1));
            }
            throw new NotContextException(firstComponent + " is not a Context");
        }
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return __root.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return __root.getNameParser(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            return this.list(__root.getNameParser("").parse(this.getSuffix(name)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                List empty = Collections.emptyList();
                return new NameEnumeration(empty.iterator());
            }
            if (cname.size() == 0) {
                return new NameEnumeration(__root.getBindings().values().iterator());
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = __root.getBinding(firstComponent);
                if (binding == null) {
                    throw new NameNotFoundException();
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    if (__log.isDebugEnabled()) {
                        __log.debug("Dereferencing Reference for " + name.get(0), new Object[0]);
                    }
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (!(ctx instanceof Context)) {
                throw new NotContextException();
            }
            return ((Context)ctx).list(cname.getSuffix(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            Name cname = __root.toCanonicalName(name);
            if (cname == null) {
                List empty = Collections.emptyList();
                return new BindingEnumeration(empty.iterator());
            }
            if (cname.size() == 0) {
                return new BindingEnumeration(__root.getBindings().values().iterator());
            }
            String firstComponent = cname.get(0);
            Object ctx = null;
            if (firstComponent.equals("")) {
                ctx = this;
            } else {
                Binding binding = __root.getBinding(firstComponent);
                if (binding == null) {
                    throw new NameNotFoundException();
                }
                ctx = binding.getObject();
                if (ctx instanceof Reference) {
                    try {
                        ctx = NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
                    }
                    catch (NamingException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        __log.warn("", e);
                        throw new NamingException(e.getMessage());
                    }
                }
            }
            if (!(ctx instanceof Context)) {
                throw new NotContextException();
            }
            return ((Context)ctx).listBindings(cname.getSuffix(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(String name) throws NamingException {
        NamingContext namingContext = __root;
        synchronized (namingContext) {
            return this.listBindings(__root.getNameParser("").parse(this.getSuffix(name)));
        }
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._env.put(propName, propVal);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return __root.composeName(name, prefix);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return __root.composeName(name, prefix);
    }

    protected String getSuffix(String url) throws NamingException {
        return url;
    }

    protected Name getSuffix(Name name) throws NamingException {
        return name;
    }

    static class LocalNameParser
    implements NameParser {
        Properties syntax = new Properties();

        LocalNameParser() {
            this.syntax.put("jndi.syntax.direction", "left_to_right");
            this.syntax.put("jndi.syntax.separator", "/");
            this.syntax.put("jndi.syntax.ignorecase", "false");
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, this.syntax);
        }
    }

    static class NamingRoot
    extends NamingContext {
        public NamingRoot() {
            super(null, null, null, new LocalNameParser());
        }
    }
}

