/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class QueuedHttpInput
extends HttpInput {
    private static final Logger LOG = Log.getLogger(QueuedHttpInput.class);
    private final ArrayQueue<HttpInput.Content> _inputQ = new ArrayQueue(this.lock());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void content(HttpInput.Content item) {
        Object object = this.lock();
        synchronized (object) {
            boolean wasEmpty = this._inputQ.isEmpty();
            this._inputQ.add((Object)item);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} queued {}", new Object[]{this, item});
            }
            if (wasEmpty && !this.onAsyncRead()) {
                this.lock().notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            HttpInput.Content item = (HttpInput.Content)((Object)this._inputQ.pollUnsafe());
            while (item != null) {
                item.failed(null);
                item = (HttpInput.Content)((Object)this._inputQ.pollUnsafe());
            }
            super.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpInput.Content nextContent() {
        Object object = this.lock();
        synchronized (object) {
            HttpInput.Content item = (HttpInput.Content)((Object)this._inputQ.peekUnsafe());
            while (item != null && this.remaining(item) == 0) {
                this._inputQ.pollUnsafe();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} consumed {}", new Object[]{this, item});
                }
                item = (HttpInput.Content)((Object)this._inputQ.peekUnsafe());
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void blockForContent() throws IOException {
        Object object = this.lock();
        synchronized (object) {
            while (this._inputQ.isEmpty() && !this.isFinished() && !this.isEOF()) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} waiting for content", new Object[]{this});
                    }
                    this.lock().wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            super.earlyEOF();
            this.lock().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageComplete() {
        Object object = this.lock();
        synchronized (object) {
            super.messageComplete();
            this.lock().notify();
        }
    }
}

