/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpParser;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AsyncIOServletTest {
    private Server server;
    private ServerConnector connector;
    private ServletContextHandler context;
    private String path = "/path";

    public void startServer(HttpServlet servlet) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        this.context = new ServletContextHandler((HandlerContainer)this.server, "/", false, false);
        ServletHolder holder = new ServletHolder((Servlet)servlet);
        holder.setAsyncSupported(true);
        this.context.addServlet(holder, this.path);
        this.server.start();
    }

    @After
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testAsyncReadThrowsException() throws Exception {
        this.testAsyncReadThrows(new NullPointerException("explicitly_thrown_by_test"));
    }

    @Test
    public void testAsyncReadThrowsError() throws Exception {
        this.testAsyncReadThrows(new Error("explicitly_thrown_by_test"));
    }

    private void testAsyncReadThrows(final Throwable throwable) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw new IOException(throwable);
                    }

                    public void onAllDataRead() throws IOException {
                    }

                    public void onError(Throwable t) {
                        Assert.assertThat((String)"onError type", (Object)t, (Matcher)Matchers.instanceOf(throwable.getClass()));
                        Assert.assertThat((String)"onError message", (Object)t.getMessage(), (Matcher)Matchers.is((Object)throwable.getMessage()));
                        latch.countDown();
                        response.setStatus(500);
                        asyncContext.complete();
                    }
                });
            }
        });
        String data = "0123456789";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + data.length() + "\r\n" + "\r\n" + data;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"500", (Object)response.getCode());
        }
    }

    @Test
    public void testAsyncReadIdleTimeout() throws Exception {
        int status = 567;
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                asyncContext.setTimeout(0L);
                final ServletInputStream inputStream = request.getInputStream();
                inputStream.setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        while (inputStream.isReady() && !inputStream.isFinished()) {
                            inputStream.read();
                        }
                    }

                    public void onAllDataRead() throws IOException {
                    }

                    public void onError(Throwable t) {
                        response.setStatus(567);
                        asyncContext.complete();
                    }
                });
            }
        });
        this.server.stop();
        long idleTimeout = 1000L;
        this.connector.setIdleTimeout(idleTimeout);
        this.server.start();
        String data1 = "0123456789";
        String data2 = "ABCDEF";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + (data1.length() + data2.length()) + "\r\n" + "\r\n" + data1;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertEquals((Object)String.valueOf(567), (Object)response.getCode());
            Assert.assertEquals((long)-1L, (long)client.getInputStream().read());
        }
    }

    @Test
    public void testOnErrorThrows() throws Exception {
        final AtomicInteger errors = new AtomicInteger();
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        throw new NullPointerException("explicitly_thrown_by_test_1");
                    }

                    public void onAllDataRead() throws IOException {
                    }

                    public void onError(Throwable t) {
                        errors.incrementAndGet();
                        throw new NullPointerException("explicitly_thrown_by_test_2");
                    }
                });
            }
        });
        String data = "0123456789";
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Length: " + data.length() + "\r\n" + "\r\n" + data;
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertEquals((Object)"500", (Object)response.getCode());
            Assert.assertEquals((long)1L, (long)errors.get());
        }
    }

    @Test
    public void testAsyncWriteThrowsException() throws Exception {
        this.testAsyncWriteThrows(new NullPointerException("explicitly_thrown_by_test"));
    }

    @Test
    public void testAsyncWriteThrowsError() throws Exception {
        this.testAsyncWriteThrows(new Error("explicitly_thrown_by_test"));
    }

    private void testAsyncWriteThrows(final Throwable throwable) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                        throw new IOException(throwable);
                    }

                    public void onError(Throwable t) {
                        latch.countDown();
                        response.setStatus(500);
                        asyncContext.complete();
                        Assert.assertSame((Object)throwable, (Object)t);
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            SimpleHttpParser parser = new SimpleHttpParser();
            SimpleHttpResponse response = parser.readResponse(new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8")));
            Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"500", (Object)response.getCode());
        }
    }

    @Test
    public void testAsyncWriteClosed() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String text = "Now is the winter of our discontent. How Now Brown Cow. The quick brown fox jumped over the lazy dog.\n";
        for (int i = 0; i < 10; ++i) {
            text = text + text;
        }
        final byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                final ServletOutputStream out = response.getOutputStream();
                out.setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        while (out.isReady()) {
                            try {
                                Thread.sleep(100L);
                                out.write(data);
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void onError(Throwable t) {
                        async.complete();
                        latch.countDown();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)" ")));
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"discontent. How Now Brown Cow. The "));
        }
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail();
        }
    }

    @Test
    public void testIsNotReadyAtEOF() throws Exception {
        String text = "Test\n";
        final byte[] data = text.getBytes(StandardCharsets.ISO_8859_1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.flushBuffer();
                final AsyncContext async = request.startAsync();
                final ServletInputStream in = request.getInputStream();
                final ServletOutputStream out = response.getOutputStream();
                in.setReadListener(new ReadListener(){
                    transient int _i = 0;
                    transient boolean _minusOne = false;
                    transient boolean _finished = false;

                    public void onError(Throwable t) {
                        t.printStackTrace();
                        async.complete();
                    }

                    public void onDataAvailable() throws IOException {
                        while (in.isReady() && !in.isFinished()) {
                            int b = in.read();
                            if (b == -1) {
                                this._minusOne = true;
                                continue;
                            }
                            if (data[this._i++] == b) continue;
                            throw new IllegalStateException();
                        }
                        if (in.isFinished()) {
                            this._finished = true;
                        }
                    }

                    public void onAllDataRead() throws IOException {
                        out.write(String.format("i=%d eof=%b finished=%b", this._i, this._minusOne, this._finished).getBytes(StandardCharsets.ISO_8859_1));
                        async.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Content-Type: text/plain\r\n" + "Content-Length: " + data.length + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.write(data);
            output.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)"200 OK"));
            while (line.length() > 0) {
                line = in.readLine();
            }
            line = in.readLine();
            Assert.assertThat((Object)line, (Matcher)Matchers.containsString((String)("i=" + data.length + " eof=false finished=true")));
        }
    }

    @Test
    public void testEmptyAsyncRead() throws Exception {
        final AtomicBoolean oda = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        this.startServer(new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
                response.setStatus(200);
                response.getOutputStream().close();
                request.getInputStream().setReadListener(new ReadListener(){

                    public void onDataAvailable() throws IOException {
                        oda.set(true);
                    }

                    public void onAllDataRead() throws IOException {
                        asyncContext.complete();
                        latch.countDown();
                    }

                    public void onError(Throwable t) {
                        t.printStackTrace();
                        asyncContext.complete();
                    }
                });
            }
        });
        String request = "GET " + this.path + " HTTP/1.1\r\n" + "Host: localhost:" + this.connector.getLocalPort() + "\r\n" + "Connection: close\r\n" + "\r\n";
        try (Socket client = new Socket("localhost", this.connector.getLocalPort());){
            OutputStream output = client.getOutputStream();
            output.write(request.getBytes("UTF-8"));
            output.flush();
            String response = IO.toString((InputStream)client.getInputStream());
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            latch.await();
        }
        Assert.assertFalse((boolean)oda.get());
    }
}

