/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.AdvancedRunner;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AdvancedRunner.class)
public class AsyncServletTest {
    protected AsyncServlet _servlet = new AsyncServlet();
    protected int _port;
    protected Server _server = new Server();
    protected ServletHandler _servletHandler;
    protected ServerConnector _connector;
    protected List<String> _log;
    protected int _expectedLogs;
    protected String _expectedCode;
    private static AsyncListener __listener = new AsyncListener(){

        public void onTimeout(AsyncEvent event) throws IOException {
            ((HttpServletResponse)event.getSuppliedResponse()).addHeader("history", "onTimeout");
            String action = event.getSuppliedRequest().getParameter("timeout");
            if (action != null) {
                ((HttpServletResponse)event.getSuppliedResponse()).addHeader("history", action);
                if ("dispatch".equals(action)) {
                    event.getAsyncContext().dispatch();
                }
                if ("complete".equals(action)) {
                    event.getSuppliedResponse().getOutputStream().println("COMPLETED\n");
                    event.getAsyncContext().complete();
                }
            }
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            ((HttpServletResponse)event.getSuppliedResponse()).addHeader("history", "onComplete");
        }
    };

    @Before
    public void setUp() throws Exception {
        this._connector = new ServerConnector(this._server);
        this._server.setConnectors(new Connector[]{this._connector});
        this._log = new ArrayList<String>();
        Log log = new Log();
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)log);
        this._server.setHandler((Handler)logHandler);
        this._expectedLogs = 1;
        this._expectedCode = "200 ";
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/ctx");
        logHandler.setHandler((Handler)context);
        this._servletHandler = context.getServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)this._servlet);
        holder.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder, "/path/*");
        this._servletHandler.addServletWithMapping(holder, "/path1/*");
        this._servletHandler.addServletWithMapping(holder, "/path2/*");
        this._servletHandler.addServletWithMapping(holder, "/p th3/*");
        this._servletHandler.addServletWithMapping(new ServletHolder((Servlet)new FwdServlet()), "/fwd/*");
        this._server.start();
        this._port = this._connector.getLocalPort();
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertEquals((long)this._expectedLogs, (long)this._log.size());
        Assert.assertThat((Object)this._log.get(0), (Matcher)Matchers.containsString((String)this._expectedCode));
        this._server.stop();
    }

    @Test
    public void testNormal() throws Exception {
        String response = this.process(null, null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\n", response);
        this.assertContains("NORMAL", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: onComplete", response);
    }

    @Test
    public void testSleep() throws Exception {
        String response = this.process("sleep=200", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\n", response);
        this.assertContains("SLEPT", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: onComplete", response);
    }

    @Test
    public void testSuspend() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("suspend=200", null);
        Assert.assertEquals((Object)"HTTP/1.1 500 Async Timeout", (Object)response.substring(0, 26));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("ERROR: /ctx/path/info", response);
    }

    @Test
    public void testSuspendOnTimeoutDispatch() throws Exception {
        String response = this.process("suspend=200&timeout=dispatch", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: dispatch\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testSuspendOnTimeoutComplete() throws Exception {
        String response = this.process("suspend=200&timeout=complete", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: complete\r\nhistory: onComplete\r\n", response);
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testSuspendWaitResume() throws Exception {
        String response = this.process("suspend=200&resume=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertNotContains("history: onTimeout", response);
    }

    @Test
    public void testSuspendResume() throws Exception {
        String response = this.process("suspend=200&resume=0", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("history: onComplete", response);
    }

    @Test
    public void testSuspendWaitComplete() throws Exception {
        String response = this.process("suspend=200&complete=50", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: complete\r\nhistory: onComplete\r\n", response);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: !initial", response);
    }

    @Test
    public void testSuspendComplete() throws Exception {
        String response = this.process("suspend=200&complete=0", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: complete\r\nhistory: onComplete\r\n", response);
        this.assertContains("COMPLETED", response);
        this.assertNotContains("history: onTimeout", response);
        this.assertNotContains("history: !initial", response);
    }

    @Test
    public void testSuspendWaitResumeSuspendWaitResume() throws Exception {
        String response = this.process("suspend=1000&resume=10&suspend2=1000&resume2=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testSuspendWaitResumeSuspendComplete() throws Exception {
        String response = this.process("suspend=1000&resume=10&suspend2=1000&complete2=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: complete\r\nhistory: onComplete\r\n", response);
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testSuspendWaitResumeSuspend() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("suspend=1000&resume=10&suspend2=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 500 Async Timeout", (Object)response.substring(0, 26));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("ERROR: /ctx/path/info", response);
    }

    @Test
    public void testSuspendTimeoutSuspendResume() throws Exception {
        String response = this.process("suspend=10&suspend2=1000&resume2=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testSuspendTimeoutSuspendComplete() throws Exception {
        String response = this.process("suspend=10&suspend2=1000&complete2=10", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: complete\r\nhistory: onComplete\r\n", response);
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testSuspendTimeoutSuspend() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("suspend=10&suspend2=10", null);
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: suspend\r\nhistory: onTimeout\r\nhistory: ERROR /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("ERROR: /ctx/path/info", response);
    }

    @Test
    public void testWrapStartDispatch() throws Exception {
        String response = this.process("wrap=true&suspend=200&resume=20", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: wrapped REQ RSP\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartDispatchEncodedPath() throws Exception {
        String response = this.process("suspend=200&resume=20&path=/p%20th3", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/p%20th3\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdStartDispatch() throws Exception {
        String response = this.process("fwd", "suspend=200&resume=20", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: FWD REQUEST /ctx/fwd/info\r\nhistory: FORWARD /ctx/path1\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: FWD ASYNC /ctx/fwd/info\r\nhistory: FORWARD /ctx/path1\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdStartDispatchPath() throws Exception {
        String response = this.process("fwd", "suspend=200&resume=20&path=/path2", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: FWD REQUEST /ctx/fwd/info\r\nhistory: FORWARD /ctx/path1\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path2\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdWrapStartDispatch() throws Exception {
        String response = this.process("fwd", "wrap=true&suspend=200&resume=20", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: FWD REQUEST /ctx/fwd/info\r\nhistory: FORWARD /ctx/path1\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path1\r\nhistory: wrapped REQ RSP\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdWrapStartDispatchPath() throws Exception {
        String response = this.process("fwd", "wrap=true&suspend=200&resume=20&path=/path2", null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
        this.assertContains("history: FWD REQUEST /ctx/fwd/info\r\nhistory: FORWARD /ctx/path1\r\nhistory: initial\r\nhistory: suspend\r\nhistory: resume\r\nhistory: ASYNC /ctx/path2\r\nhistory: wrapped REQ RSP\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testAsyncRead() throws Exception {
        this._expectedLogs = 2;
        String header = "GET /ctx/path/info?suspend=2000&resume=1500 HTTP/1.1\r\nHost: localhost\r\nContent-Length: 10\r\n\r\n";
        String body = "12345678\r\n";
        String close = "GET /ctx/path/info HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        try (Socket socket = new Socket("localhost", this._port);){
            socket.setSoTimeout(10000);
            socket.getOutputStream().write(header.getBytes(StandardCharsets.ISO_8859_1));
            Thread.sleep(500L);
            socket.getOutputStream().write(body.getBytes(StandardCharsets.ISO_8859_1), 0, 2);
            Thread.sleep(500L);
            socket.getOutputStream().write(body.getBytes(StandardCharsets.ISO_8859_1), 2, 8);
            socket.getOutputStream().write(close.getBytes(StandardCharsets.ISO_8859_1));
            String response = IO.toString((InputStream)socket.getInputStream());
            Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)response.substring(0, 15));
            this.assertContains("history: REQUEST /ctx/path/info\r\nhistory: initial\r\nhistory: suspend\r\nhistory: async-read=10\r\nhistory: resume\r\nhistory: ASYNC /ctx/path/info\r\nhistory: !initial\r\nhistory: onComplete\r\n", response);
        }
    }

    public synchronized String process(String query, String content) throws Exception {
        return this.process("path", query, content);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String process(String path, String query, String content) throws Exception {
        String request = "GET /ctx/" + path + "/info";
        if (query != null) {
            request = request + "?" + query;
        }
        request = request + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n";
        if (content == null) {
            request = request + "\r\n";
        } else {
            request = request + "Content-Length: " + content.length() + "\r\n";
            request = request + "\r\n" + content;
        }
        int port = this._port;
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(1000000);
            socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
            String string = IO.toString((InputStream)socket.getInputStream());
            return string;
        }
        catch (Exception e) {
            System.err.println("failed on port " + port);
            e.printStackTrace();
            throw e;
        }
    }

    protected void assertContains(String content, String response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)content));
    }

    protected void assertNotContains(String content, String response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)content)));
    }

    class Log
    extends AbstractLifeCycle
    implements RequestLog {
        Log() {
        }

        public void log(Request request, Response response) {
            AsyncServletTest.this._log.add(response.getStatus() + " " + response.getContentCount() + " " + request.getRequestURI());
        }
    }

    private static class AsyncServlet
    extends HttpServlet {
        private static final long serialVersionUID = -8161977157098646562L;
        private final Timer _timer = new Timer();

        private AsyncServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
            try {
                request.getAsyncContext();
                throw new IllegalStateException();
            }
            catch (IllegalStateException e) {
                response.addHeader("history", request.getDispatcherType() + " " + request.getRequestURI());
                if (request instanceof ServletRequestWrapper || response instanceof ServletResponseWrapper) {
                    response.addHeader("history", "wrapped" + (request instanceof ServletRequestWrapper ? " REQ" : "") + (response instanceof ServletResponseWrapper ? " RSP" : ""));
                }
                boolean wrap = "true".equals(request.getParameter("wrap"));
                int read_before = 0;
                long sleep_for = -1L;
                long suspend_for = -1L;
                long suspend2_for = -1L;
                long resume_after = -1L;
                long resume2_after = -1L;
                long complete_after = -1L;
                long complete2_after = -1L;
                if (request.getParameter("read") != null) {
                    read_before = Integer.parseInt(request.getParameter("read"));
                }
                if (request.getParameter("sleep") != null) {
                    sleep_for = Integer.parseInt(request.getParameter("sleep"));
                }
                if (request.getParameter("suspend") != null) {
                    suspend_for = Integer.parseInt(request.getParameter("suspend"));
                }
                if (request.getParameter("suspend2") != null) {
                    suspend2_for = Integer.parseInt(request.getParameter("suspend2"));
                }
                if (request.getParameter("resume") != null) {
                    resume_after = Integer.parseInt(request.getParameter("resume"));
                }
                final String path = request.getParameter("path");
                if (request.getParameter("resume2") != null) {
                    resume2_after = Integer.parseInt(request.getParameter("resume2"));
                }
                if (request.getParameter("complete") != null) {
                    complete_after = Integer.parseInt(request.getParameter("complete"));
                }
                if (request.getParameter("complete2") != null) {
                    complete2_after = Integer.parseInt(request.getParameter("complete2"));
                }
                if (request.getAttribute("State") == null) {
                    request.setAttribute("State", (Object)new Integer(1));
                    response.addHeader("history", "initial");
                    if (read_before > 0) {
                        byte[] buf = new byte[read_before];
                        request.getInputStream().read(buf);
                    } else if (read_before < 0) {
                        ServletInputStream in = request.getInputStream();
                        int b = in.read();
                        while (b != -1) {
                            b = in.read();
                        }
                    } else if (request.getContentLength() > 0) {
                        new Thread(){

                            @Override
                            public void run() {
                                int c = 0;
                                try {
                                    ServletInputStream in = request.getInputStream();
                                    int b = 0;
                                    while (b != -1) {
                                        b = in.read();
                                        if (b < 0) continue;
                                        ++c;
                                    }
                                    response.addHeader("history", "async-read=" + c);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    }
                    if (suspend_for >= 0L) {
                        AsyncContext async;
                        AsyncContext asyncContext = async = wrap ? request.startAsync((ServletRequest)new HttpServletRequestWrapper(request), (ServletResponse)new HttpServletResponseWrapper(response)) : request.startAsync();
                        if (suspend_for > 0L) {
                            async.setTimeout(suspend_for);
                        }
                        async.addListener(__listener);
                        response.addHeader("history", "suspend");
                        if (complete_after > 0L) {
                            TimerTask complete = new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        response.setStatus(200);
                                        response.getOutputStream().println("COMPLETED\n");
                                        response.addHeader("history", "complete");
                                        async.complete();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(complete, complete_after);
                            }
                        } else if (complete_after == 0L) {
                            response.setStatus(200);
                            response.getOutputStream().println("COMPLETED\n");
                            response.addHeader("history", "complete");
                            async.complete();
                        } else if (resume_after > 0L) {
                            TimerTask resume = new TimerTask(){

                                @Override
                                public void run() {
                                    ((HttpServletResponse)async.getResponse()).addHeader("history", "resume");
                                    if (path != null) {
                                        int q = path.indexOf(63);
                                        String uriInContext = q >= 0 ? URIUtil.encodePath((String)path.substring(0, q)) + path.substring(q) : URIUtil.encodePath((String)path);
                                        async.dispatch(uriInContext);
                                    } else {
                                        async.dispatch();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(resume, resume_after);
                            }
                        } else if (resume_after == 0L) {
                            ((HttpServletResponse)async.getResponse()).addHeader("history", "resume");
                            if (path != null) {
                                async.dispatch(path);
                            } else {
                                async.dispatch();
                            }
                        }
                    } else if (sleep_for >= 0L) {
                        try {
                            Thread.sleep(sleep_for);
                        }
                        catch (InterruptedException e2) {
                            e2.printStackTrace();
                        }
                        response.setStatus(200);
                        response.getOutputStream().println("SLEPT\n");
                    } else {
                        response.setStatus(200);
                        response.getOutputStream().println("NORMAL\n");
                    }
                } else {
                    response.addHeader("history", "!initial");
                    if (suspend2_for >= 0L && request.getAttribute("2nd") == null) {
                        final AsyncContext async = wrap ? request.startAsync((ServletRequest)new HttpServletRequestWrapper(request), (ServletResponse)new HttpServletResponseWrapper(response)) : request.startAsync();
                        async.addListener(__listener);
                        request.setAttribute("2nd", (Object)"cycle");
                        if (suspend2_for > 0L) {
                            async.setTimeout(suspend2_for);
                        }
                        response.addHeader("history", "suspend");
                        if (complete2_after > 0L) {
                            TimerTask complete = new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        response.setStatus(200);
                                        response.getOutputStream().println("COMPLETED\n");
                                        response.addHeader("history", "complete");
                                        async.complete();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(complete, complete2_after);
                            }
                        } else if (complete2_after == 0L) {
                            response.setStatus(200);
                            response.getOutputStream().println("COMPLETED\n");
                            response.addHeader("history", "complete");
                            async.complete();
                        } else if (resume2_after > 0L) {
                            TimerTask resume = new TimerTask(){

                                @Override
                                public void run() {
                                    response.addHeader("history", "resume");
                                    async.dispatch();
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(resume, resume2_after);
                            }
                        } else if (resume2_after == 0L) {
                            response.addHeader("history", "dispatch");
                            async.dispatch();
                        }
                    } else if (request.getDispatcherType() == DispatcherType.ERROR) {
                        response.getOutputStream().println("ERROR: " + request.getContextPath() + request.getServletPath() + request.getPathInfo());
                    } else {
                        response.setStatus(200);
                        response.getOutputStream().println("DISPATCHED");
                    }
                }
                return;
            }
        }
    }

    private static class FwdServlet
    extends HttpServlet {
        private FwdServlet() {
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.addHeader("history", "FWD " + request.getDispatcherType() + " " + request.getRequestURI());
            if (request instanceof ServletRequestWrapper || response instanceof ServletResponseWrapper) {
                response.addHeader("history", "wrapped" + (request instanceof ServletRequestWrapper ? " REQ" : "") + (response instanceof ServletResponseWrapper ? " RSP" : ""));
            }
            request.getServletContext().getRequestDispatcher("/path1").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

