/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServletHandlerTest {
    FilterHolder fh1 = new FilterHolder(BaseHolder.Source.DESCRIPTOR);
    FilterMapping fm1 = new FilterMapping();
    FilterHolder fh2 = new FilterHolder(BaseHolder.Source.DESCRIPTOR);
    FilterMapping fm2 = new FilterMapping();
    FilterHolder fh3 = new FilterHolder(BaseHolder.Source.JAVAX_API);
    FilterMapping fm3 = new FilterMapping();
    FilterHolder fh4 = new FilterHolder(BaseHolder.Source.JAVAX_API);
    FilterMapping fm4 = new FilterMapping();
    FilterHolder fh5 = new FilterHolder(BaseHolder.Source.JAVAX_API);
    FilterMapping fm5 = new FilterMapping();

    @Before
    public void initMappings() {
        this.fh1.setName("fh1");
        this.fm1.setPathSpec("/*");
        this.fm1.setFilterHolder(this.fh1);
        this.fh2.setName("fh2");
        this.fm2.setPathSpec("/*");
        this.fm2.setFilterHolder(this.fh2);
        this.fh3.setName("fh3");
        this.fm3.setPathSpec("/*");
        this.fm3.setFilterHolder(this.fh3);
        this.fh4.setName("fh4");
        this.fm4.setPathSpec("/*");
        this.fm4.setFilterHolder(this.fh4);
        this.fh5.setName("fh5");
        this.fm5.setPathSpec("/*");
        this.fm5.setFilterHolder(this.fh5);
    }

    @Test
    public void testAllNonProgrammaticFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilter(this.fh2);
        handler.addFilterMapping(this.fm1);
        handler.addFilterMapping(this.fm2);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        FilterHolder of1 = new FilterHolder(BaseHolder.Source.DESCRIPTOR);
        FilterMapping ofm1 = new FilterMapping();
        ofm1.setFilterHolder(of1);
        ofm1.setPathSpec("/*");
        handler.addFilter(of1);
        handler.addFilterMapping(ofm1);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((ofm1 == mappings[2] ? 1 : 0) != 0);
    }

    @Test
    public void testAllBeforeFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.length);
        handler.addFilter(this.fh5);
        handler.prependFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testAllAfterFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh4);
        handler.addFilterMapping(this.fm4);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertEquals((long)1L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.addFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testMatchAfterAndBefore() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh3);
        handler.addFilterMapping(this.fm3);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.length);
        Assert.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testMatchBeforeAndAfter() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh3);
        handler.prependFilterMapping(this.fm3);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)1L, (long)mappings.length);
        Assert.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.addFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fm3 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm4 == mappings[1] ? 1 : 0) != 0);
    }

    @Test
    public void testExistingFilterMappings() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilter(this.fh2);
        handler.addFilterMapping(this.fm1);
        handler.addFilterMapping(this.fm2);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm2 == mappings[1] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assert.assertEquals((long)3L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.addFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assert.assertEquals((long)4L, (long)mappings.length);
        Assert.assertTrue((this.fm5 == mappings[mappings.length - 1] ? 1 : 0) != 0);
    }

    @Test
    public void testFilterMappingsMix() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilter(this.fh1);
        handler.addFilterMapping(this.fm1);
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((this.fm1 == mappings[0] ? 1 : 0) != 0);
        handler.addFilter(this.fh4);
        handler.prependFilterMapping(this.fm4);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[1] ? 1 : 0) != 0);
        handler.addFilter(this.fh3);
        handler.addFilterMapping(this.fm3);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)3L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[2] ? 1 : 0) != 0);
        handler.addFilter(this.fh5);
        handler.prependFilterMapping(this.fm5);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)4L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[3] ? 1 : 0) != 0);
        FilterHolder f = new FilterHolder(BaseHolder.Source.EMBEDDED);
        f.setName("non-programmatic");
        FilterMapping fm = new FilterMapping();
        fm.setFilterHolder(f);
        fm.setPathSpec("/*");
        handler.addFilter(f);
        handler.addFilterMapping(fm);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)5L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assert.assertTrue((fm == mappings[3] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[4] ? 1 : 0) != 0);
        FilterHolder pf = new FilterHolder(BaseHolder.Source.JAVAX_API);
        pf.setName("programmaticA");
        FilterMapping pfm = new FilterMapping();
        pfm.setFilterHolder(pf);
        pfm.setPathSpec("/*");
        handler.addFilter(pf);
        handler.addFilterMapping(pfm);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)6L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[2] ? 1 : 0) != 0);
        Assert.assertTrue((fm == mappings[3] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[4] ? 1 : 0) != 0);
        Assert.assertTrue((pfm == mappings[5] ? 1 : 0) != 0);
        FilterHolder pf2 = new FilterHolder(BaseHolder.Source.JAVAX_API);
        pf2.setName("programmaticB");
        FilterMapping pfm2 = new FilterMapping();
        pfm2.setFilterHolder(pf2);
        pfm2.setPathSpec("/*");
        handler.addFilter(pf2);
        handler.prependFilterMapping(pfm2);
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)7L, (long)mappings.length);
        Assert.assertTrue((this.fm4 == mappings[0] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm5 == mappings[1] ? 1 : 0) != 0);
        Assert.assertTrue((pfm2 == mappings[2] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm1 == mappings[3] ? 1 : 0) != 0);
        Assert.assertTrue((fm == mappings[4] ? 1 : 0) != 0);
        Assert.assertTrue((this.fm3 == mappings[5] ? 1 : 0) != 0);
        Assert.assertTrue((pfm == mappings[6] ? 1 : 0) != 0);
    }

    @Test
    public void testAddFilterWithMappingAPI() throws Exception {
        ServletHandler handler = new ServletHandler();
        handler.addFilterWithMapping(this.fh1, "/*", EnumSet.allOf(DispatcherType.class));
        handler.updateMappings();
        FilterMapping[] mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertTrue((this.fh1 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        this.fh4.setServletHandler(handler);
        handler.addFilter(this.fh4);
        this.fh4.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)2L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        this.fh3.setServletHandler(handler);
        handler.addFilter(this.fh3);
        this.fh3.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)3L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh3 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        this.fh5.setServletHandler(handler);
        handler.addFilter(this.fh5);
        this.fh5.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)4L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh3 == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder f = new FilterHolder(BaseHolder.Source.EMBEDDED);
        f.setName("non-programmatic");
        handler.addFilterWithMapping(f, "/*", EnumSet.allOf(DispatcherType.class));
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)5L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((f == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh3 == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder pf = new FilterHolder(BaseHolder.Source.JAVAX_API);
        pf.setServletHandler(handler);
        pf.setName("programmaticA");
        handler.addFilter(pf);
        pf.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)6L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((f == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh3 == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((pf == mappings[5].getFilterHolder() ? 1 : 0) != 0);
        FilterHolder pf2 = new FilterHolder(BaseHolder.Source.JAVAX_API);
        pf2.setServletHandler(handler);
        pf2.setName("programmaticB");
        handler.addFilter(pf2);
        pf2.getRegistration().addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        handler.updateMappings();
        mappings = handler.getFilterMappings();
        Assert.assertNotNull((Object)mappings);
        Assert.assertEquals((long)7L, (long)mappings.length);
        Assert.assertTrue((this.fh4 == mappings[0].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh5 == mappings[1].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((pf2 == mappings[2].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh1 == mappings[3].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((f == mappings[4].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((this.fh3 == mappings[5].getFilterHolder() ? 1 : 0) != 0);
        Assert.assertTrue((pf == mappings[6].getFilterHolder() ? 1 : 0) != 0);
    }
}

