/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AsyncListenerTest {
    private QueuedThreadPool threadPool;
    private Server server;
    private LocalConnector connector;

    public void startServer(ServletContextHandler context) throws Exception {
        this.server = this.threadPool == null ? new Server() : new Server((ThreadPool)this.threadPool);
        this.connector = new LocalConnector(this.server);
        this.connector.setIdleTimeout(1200000L);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)context);
        this.server.start();
    }

    @After
    public void dispose() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void test_StartAsync_Throw_OnError_Dispatch() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> event.getAsyncContext().dispatch("/dispatch"));
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
    }

    @Test
    public void test_StartAsync_Throw_OnError_Complete() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            response.setStatus(500);
            ServletOutputStream output = response.getOutputStream();
            output.println(event.getThrowable().getClass().getName());
            if (event.getThrowable().getCause() != null) {
                output.println(event.getThrowable().getCause().getClass().getName());
            }
            output.println("COMPLETE");
            event.getAsyncContext().complete();
        });
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)TestRuntimeException.class.getName()));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"COMPLETE"));
    }

    @Test
    public void test_StartAsync_Throw_OnError_Throw() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> {
            throw new IOException();
        });
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)TestRuntimeException.class.getName()));
    }

    @Test
    public void test_StartAsync_Throw_OnError_Nothing() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> {});
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)TestRuntimeException.class.getName()));
    }

    @Test
    public void test_StartAsync_Throw_OnError_SendError() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            response.sendError(502);
        });
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 502 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)TestRuntimeException.class.getName()));
    }

    @Test
    public void test_StartAsync_Throw_OnError_SendError_CustomErrorPage() throws Exception {
        this.test_StartAsync_Throw_OnError(event -> {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            response.sendError(502);
        });
        ErrorHandler errorHandler = new ErrorHandler(){

            protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
                writer.write("CUSTOM\n");
                super.writeErrorPageMessage(request, writer, code, message, uri);
            }
        };
        this.server.setErrorHandler(errorHandler);
        String httpResponse = this.connector.getResponse("GET /ctx/path HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n", 10L, TimeUnit.MINUTES);
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 502 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"CUSTOM"));
    }

    private void test_StartAsync_Throw_OnError(final IOConsumer<AsyncEvent> consumer) throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/ctx");
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(0L);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onError(AsyncEvent event) throws IOException {
                        consumer.accept(event);
                    }
                });
                throw new QuietServletException((Throwable)new TestRuntimeException());
            }
        }), "/path/*");
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.setStatus(200);
            }
        }), "/dispatch/*");
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getOutputStream().print("CUSTOM");
            }
        }), "/error/*");
        this.startServer(context);
    }

    @Test
    public void test_StartAsync_OnTimeout_Dispatch() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> event.getAsyncContext().dispatch("/dispatch"));
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
    }

    @Test
    public void test_StartAsync_OnTimeout_Complete() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            response.setStatus(200);
            ServletOutputStream output = response.getOutputStream();
            output.println("COMPLETE");
            event.getAsyncContext().complete();
        });
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"COMPLETE"));
    }

    @Test
    public void test_StartAsync_OnTimeout_Throw() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> {
            throw new TestRuntimeException();
        });
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)TestRuntimeException.class.getName()));
    }

    @Test
    public void test_StartAsync_OnTimeout_Nothing() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> {});
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 500 "));
    }

    @Test
    public void test_StartAsync_OnTimeout_SendError() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> {
            HttpServletResponse response = (HttpServletResponse)event.getAsyncContext().getResponse();
            response.sendError(502);
        });
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 502 "));
    }

    @Test
    public void test_StartAsync_OnTimeout_SendError_CustomErrorPage() throws Exception {
        this.test_StartAsync_OnTimeout(500L, event -> {
            AsyncContext asyncContext = event.getAsyncContext();
            HttpServletResponse response = (HttpServletResponse)asyncContext.getResponse();
            response.sendError(502);
            asyncContext.complete();
        });
        ErrorHandler errorHandler = new ErrorHandler(){

            protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
                writer.write("CUSTOM\n");
                super.writeErrorPageMessage(request, writer, code, message, uri);
            }
        };
        errorHandler.setServer(this.server);
        this.server.setErrorHandler(errorHandler);
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 502 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"CUSTOM"));
    }

    private void test_StartAsync_OnTimeout(final long timeout, final IOConsumer<AsyncEvent> consumer) throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(timeout);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onTimeout(AsyncEvent event) throws IOException {
                        consumer.accept(event);
                    }
                });
            }
        }), "/*");
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.setStatus(200);
            }
        }), "/dispatch/*");
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.getOutputStream().print("CUSTOM");
            }
        }), "/error/*");
        this.startServer(context);
    }

    @Test
    public void test_StartAsync_OnComplete_Throw() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(0L);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onComplete(AsyncEvent event) throws IOException {
                        throw new TestRuntimeException();
                    }
                });
                response.getOutputStream().print("DATA");
                asyncContext.complete();
            }
        }), "/*");
        this.startServer(context);
        String httpResponse = this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 "));
        Assert.assertThat((Object)httpResponse, (Matcher)Matchers.containsString((String)"DATA"));
    }

    @Test
    public void test_StartAsync_OnTimeout_CalledBy_PooledThread() throws Exception {
        final String threadNamePrefix = "async_listener";
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setName(threadNamePrefix);
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
                final AsyncContext asyncContext = request.startAsync();
                asyncContext.setTimeout(1000L);
                asyncContext.addListener((AsyncListener)new AsyncListenerAdapter(){

                    @Override
                    public void onTimeout(AsyncEvent event) throws IOException {
                        if (Thread.currentThread().getName().startsWith(threadNamePrefix)) {
                            response.setStatus(200);
                        } else {
                            response.setStatus(500);
                        }
                        asyncContext.complete();
                    }
                });
            }
        }), "/*");
        this.startServer(context);
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @FunctionalInterface
    private static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    public static class AsyncListenerAdapter
    implements AsyncListener {
        public void onComplete(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }
    }

    public static class TestRuntimeException
    extends RuntimeException {
    }
}

