/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.TestTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class AsyncServletLongPollTest {
    @Rule
    public TestTracker tracker = new TestTracker();
    private Server server;
    private ServerConnector connector;
    private ServletContextHandler context;
    private String uri;

    protected void prepare(HttpServlet servlet) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        String contextPath = "/context";
        this.context = new ServletContextHandler((HandlerContainer)this.server, contextPath, 0);
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        String servletPath = "/path";
        this.context.addServlet(servletHolder, servletPath);
        this.uri = contextPath + servletPath;
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
    }

    @Test
    public void testSuspendedRequestCompletedByAnotherRequest() throws Exception {
        final CountDownLatch asyncLatch = new CountDownLatch(1);
        this.prepare(new HttpServlet(){
            private volatile AsyncContext asyncContext;

            protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                int suspend = 0;
                String param = request.getParameter("suspend");
                if (param != null) {
                    suspend = Integer.parseInt(param);
                }
                if (suspend > 0) {
                    this.asyncContext = request.startAsync();
                    asyncLatch.countDown();
                }
            }

            protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                AsyncContext asyncContext;
                int error = 0;
                String param = request.getParameter("error");
                if (param != null) {
                    error = Integer.parseInt(param);
                }
                if ((asyncContext = this.asyncContext) != null) {
                    HttpServletResponse asyncResponse = (HttpServletResponse)asyncContext.getResponse();
                    asyncResponse.sendError(error);
                    asyncContext.complete();
                } else {
                    response.sendError(404);
                }
            }
        });
        try (Socket socket1 = new Socket("localhost", this.connector.getLocalPort());){
            int wait = 1000;
            String request1 = "GET " + this.uri + "?suspend=" + wait + " HTTP/1.1\r\nHost: localhost:" + this.connector.getLocalPort() + "\r\n\r\n";
            OutputStream output1 = socket1.getOutputStream();
            output1.write(request1.getBytes(StandardCharsets.UTF_8));
            output1.flush();
            Assert.assertTrue((boolean)asyncLatch.await(5L, TimeUnit.SECONDS));
            int error = 408;
            try (Socket socket2 = new Socket("localhost", this.connector.getLocalPort());){
                String request2 = "DELETE " + this.uri + "?error=" + error + " HTTP/1.1\r\nHost: localhost:" + this.connector.getLocalPort() + "\r\n\r\n";
                OutputStream output2 = socket2.getOutputStream();
                output2.write(request2.getBytes(StandardCharsets.UTF_8));
                output2.flush();
                HttpTester.Input input2 = HttpTester.from((InputStream)socket2.getInputStream());
                HttpTester.Response response2 = HttpTester.parseResponse((HttpTester.Input)input2);
                Assert.assertEquals((long)200L, (long)response2.getStatus());
            }
            socket1.setSoTimeout(2 * wait);
            HttpTester.Input input1 = HttpTester.from((InputStream)socket1.getInputStream());
            HttpTester.Response response1 = HttpTester.parseResponse((HttpTester.Input)input1);
            Assert.assertEquals((long)error, (long)response1.getStatus());
            String request3 = "GET " + this.uri + " HTTP/1.1\r\nHost: localhost:" + this.connector.getLocalPort() + "\r\n\r\n";
            output1.write(request3.getBytes(StandardCharsets.UTF_8));
            output1.flush();
            HttpTester.Response response3 = HttpTester.parseResponse((HttpTester.Input)input1);
            Assert.assertEquals((long)200L, (long)response3.getStatus());
        }
    }
}

