/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DispatcherForwardTest {
    private Server server;
    private LocalConnector connector;
    private HttpServlet servlet1;
    private HttpServlet servlet2;
    private List<Throwable> failures = new ArrayList<Throwable>();

    public void prepare() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/");
        context.addServlet(new ServletHolder((Servlet)this.servlet1), "/one");
        context.addServlet(new ServletHolder((Servlet)this.servlet2), "/two");
        this.server.start();
    }

    @After
    public void dispose() throws Throwable {
        Iterator<Throwable> iterator = this.failures.iterator();
        if (iterator.hasNext()) {
            Throwable failure = iterator.next();
            throw failure;
        }
        this.server.stop();
    }

    private <S> void checkThat(S item, Matcher<S> matcher) {
        try {
            Assert.assertThat(item, matcher);
        }
        catch (Throwable th) {
            this.failures.add(th);
        }
    }

    @Test
    public void testQueryRetainedByForwardWithoutQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
            }
        };
        this.prepare();
        String request = "GET /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryReplacedByForwardWithQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one&b=2%20two";
        String query2 = "a=3%20three";
        String query3 = "a=3%20three&b=2%20two";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one&b=2%20two"));
                req.getRequestDispatcher("/two?a=3%20three").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one&b=2%20two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=3%20three&b=2%20two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"3 three"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
            }
        };
        this.prepare();
        String request = "GET /one?a=1%20one&b=2%20two HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryMergedByForwardWithQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String query2 = "b=2%20two";
        String query3 = "b=2%20two&a=1%20one";
        this.servlet1 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two?b=2%20two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"b=2%20two&a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
            }
        };
        this.prepare();
        String request = "GET /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormByForwardWithoutQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String form = "a=2%20two";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1 one", "2 two"}));
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1 one", "2 two"}));
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "a=2%20two".length() + "\r\nConnection: close\r\n\r\n" + "a=2%20two";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormReplacedByForwardWithQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String query2 = "a=3%20three";
        String form = "a=2%20two";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two?a=3%20three").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(2, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"1 one", "2 two"}));
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=3%20three"));
                String[] values = req.getParameterValues("a");
                DispatcherForwardTest.this.checkThat(values, Matchers.notNullValue());
                DispatcherForwardTest.this.checkThat(3, Matchers.equalTo((Object)values.length));
                DispatcherForwardTest.this.checkThat(values, Matchers.arrayContainingInAnyOrder((Object[])new String[]{"3 three", "2 two", "1 one"}));
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "a=2%20two".length() + "\r\nConnection: close\r\n\r\n" + "a=2%20two";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormMergedByForwardWithQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String query2 = "c=3%20three";
        String query3 = "c=3%20three&a=1%20one";
        String form = "b=2%20two";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two?c=3%20three").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"c=3%20three&a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.equalTo((Object)"3 three"));
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "b=2%20two".length() + "\r\nConnection: close\r\n\r\n" + "b=2%20two";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testQueryAggregatesWithFormBeforeAndAfterForward() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String query2 = "c=3%20three";
        String query3 = "c=3%20three&a=1%20one";
        String form = "b=2%20two";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                req.getRequestDispatcher("/two?c=3%20three").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"c=3%20three&a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("a"), Matchers.equalTo((Object)"1 one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("b"), Matchers.equalTo((Object)"2 two"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.equalTo((Object)"3 three"));
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "b=2%20two".length() + "\r\nConnection: close\r\n\r\n" + "b=2%20two";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testContentCanBeReadViaInputStreamAfterForwardWithoutQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String form = "c=3%20three";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                ServletInputStream input = req.getInputStream();
                for (int i = 0; i < "c=3%20three".length(); ++i) {
                    DispatcherForwardTest.this.checkThat("c=3%20three".charAt(i) & 0xFFFF, Matchers.equalTo((Object)input.read()));
                }
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "c=3%20three".length() + "\r\nConnection: close\r\n\r\n" + "c=3%20three";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }

    @Test
    public void testContentCanBeReadViaInputStreamAfterForwardWithQuery() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        String query1 = "a=1%20one";
        String query2 = "b=2%20two";
        String query3 = "b=2%20two&a=1%20one";
        String form = "c=3%20three";
        this.servlet1 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                req.getRequestDispatcher("/two?b=2%20two").forward((ServletRequest)req, (ServletResponse)resp);
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"a=1%20one"));
                DispatcherForwardTest.this.checkThat(req.getParameter("c"), Matchers.nullValue());
                latch.countDown();
            }
        };
        this.servlet2 = new HttpServlet(){

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                DispatcherForwardTest.this.checkThat(req.getQueryString(), Matchers.equalTo((Object)"b=2%20two&a=1%20one"));
                ServletInputStream input = req.getInputStream();
                for (int i = 0; i < "c=3%20three".length(); ++i) {
                    DispatcherForwardTest.this.checkThat("c=3%20three".charAt(i) & 0xFFFF, Matchers.equalTo((Object)input.read()));
                }
                DispatcherForwardTest.this.checkThat(-1, Matchers.equalTo((Object)input.read()));
            }
        };
        this.prepare();
        String request = "POST /one?a=1%20one HTTP/1.1\r\nHost: localhost\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: " + "c=3%20three".length() + "\r\nConnection: close\r\n\r\n" + "c=3%20three";
        String response = this.connector.getResponse(request);
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)response, (boolean)response.startsWith("HTTP/1.1 200"));
    }
}

