/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResponseHeadersTest {
    private static Server server;
    private static LocalConnector connector;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new SimulateUpgradeServlet()), "/ws/*");
        context.addServlet(new ServletHolder((Servlet)new MultilineResponseValueServlet()), "/multiline/*");
        server.start();
    }

    @AfterClass
    public static void stopServer() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Test
    public void testResponseWebSocketHeaderFormat() throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/ws/");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        Assert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)101));
        Assert.assertThat((String)"Response Header Upgrade", (Object)response.get("Upgrade"), (Matcher)Matchers.is((Object)"WebSocket"));
        Assert.assertThat((String)"Response Header Connection", (Object)response.get("Connection"), (Matcher)Matchers.is((Object)"Upgrade"));
    }

    @Test
    public void testMultilineResponseHeaderValue() throws Exception {
        String actualPathInfo = "%0A%20Content-Type%3A%20image/png%0A%20Content-Length%3A%208%0A%20%0A%20yuck<!--";
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/multiline/" + actualPathInfo);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Connection", "close");
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        Assert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assert.assertThat((String)"Response Header Content-Type", (Object)response.get("Content-Type"), (Matcher)Matchers.is((Object)"text/plain;charset=UTF-8"));
        String expected = actualPathInfo.replaceAll("%0A", " ");
        expected = URLDecoder.decode(expected, "utf-8");
        expected = expected.trim();
        Assert.assertThat((String)"Response Header X-example", (Object)response.get("X-Example"), (Matcher)Matchers.is((Object)expected));
    }

    public static class MultilineResponseValueServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.length() > 1 && pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            response.setHeader("X-example", pathInfo);
            response.setContentType("text/plain");
            response.setCharacterEncoding("utf-8");
            response.getWriter().println("Got request uri - " + req.getRequestURI());
        }
    }

    public static class SimulateUpgradeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("Upgrade", "WebSocket");
            response.addHeader("Connection", "Upgrade");
            response.addHeader("Sec-WebSocket-Accept", "123456789==");
            response.setStatus(101);
        }
    }
}

