/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class ServletRequestLogTest {
    private static final Logger LOG = Log.getLogger(ServletRequestLogTest.class);
    @Parameterized.Parameter(value=0)
    public Servlet testServlet;
    @Parameterized.Parameter(value=1)
    public String requestPath;
    @Parameterized.Parameter(value=2)
    public String expectedLogEntry;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{new HelloServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutCompleteServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutDispatchServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnStartIOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ResponseSendErrorServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ServletExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new IOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new RuntimeExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        handlers.addHandler((Handler)requestLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(this.testServlet);
        app.addServlet(testHolder, "/test");
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_ErrorHandler_ServerBean() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ErrorHandler errorHandler = new ErrorHandler();
        server.addBean((Object)errorHandler);
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        handlers.addHandler((Handler)requestLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(this.testServlet);
        app.addServlet(testHolder, "/test");
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerCollection_SimpleErrorPageMapping() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        handlers.addHandler((Handler)requestLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(this.testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, this.requestPath, null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.debug("Response Status Code: {}", (long)statusCode);
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.debug("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandlerWrapped() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        RequestLogHandler requestLog = new RequestLogHandler();
        CaptureLog captureLog = new CaptureLog();
        requestLog.setRequestLog((RequestLog)captureLog);
        Handler origServerHandler = server.getHandler();
        requestLog.setHandler(origServerHandler);
        server.setHandler((Handler)requestLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(this.testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            int port = connector.getLocalPort();
            URI serverUri = new URI("http", null, host, port, "/test", null, null);
            HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
            try {
                connection.setAllowUserInteraction(false);
                int statusCode = connection.getResponseCode();
                LOG.info("Response Status Code: {}", new Object[]{statusCode});
                if (statusCode == 200) {
                    String content = this.getResponseContent(connection);
                    LOG.info("Response Content: {}", new Object[]{content});
                }
            }
            finally {
                connection.disconnect();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    private void assertRequestLog(CaptureLog captureLog) {
        int captureCount = captureLog.captured.size();
        if (captureCount != 1) {
            LOG.warn("Capture Log size is {}, expected to be 1", new Object[]{captureCount});
            if (captureCount > 1) {
                for (int i = 0; i < captureCount; ++i) {
                    LOG.warn("[{}] {}", new Object[]{i, captureLog.captured.get(i)});
                }
            }
            Assert.assertThat((String)"Capture Log Entry Count", (Object)captureLog.captured.size(), (Matcher)Matchers.is((Object)1));
        }
        String actual = captureLog.captured.get(0);
        Assert.assertThat((String)"Capture Log", (Object)actual, (Matcher)Matchers.is((Object)this.expectedLogEntry));
    }

    private String getResponseContent(HttpURLConnection connection) throws IOException {
        Throwable throwable = null;
        try (InputStream in = connection.getInputStream();){
            String string;
            InputStreamReader reader = new InputStreamReader(in);
            Throwable throwable2 = null;
            try {
                StringWriter writer = new StringWriter();
                IO.copy((Reader)reader, (Writer)writer);
                string = writer.toString();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ServletRequestLogTest.$closeResource(throwable2, reader);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            ServletRequestLogTest.$closeResource(throwable2, reader);
            return string;
        }
    }

    public static class CustomErrorServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
        }
    }

    private static class AsyncOnStartIOExceptionServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnStartIOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
            throw new IOException("Whoops");
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.warn("onError() -> {}", new Object[]{event});
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutDispatchServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutDispatchServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getAttribute("deep") == null) {
                AsyncContext ac = request.startAsync();
                ac.setTimeout(1000L);
                ac.addListener((AsyncListener)this);
                request.setAttribute("deep", (Object)true);
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutCompleteServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutCompleteServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class RuntimeExceptionServlet
    extends AbstractTestServlet {
        private RuntimeExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new RuntimeException("Whoops");
        }
    }

    private static class IOExceptionServlet
    extends AbstractTestServlet {
        private IOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new IOException("Whoops");
        }
    }

    private static class ServletExceptionServlet
    extends AbstractTestServlet {
        private ServletExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new ServletException("Whoops");
        }
    }

    private static class ResponseSendErrorServlet
    extends AbstractTestServlet {
        private ResponseSendErrorServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(500, "Whoops");
        }
    }

    private static class HelloServlet
    extends AbstractTestServlet {
        private HelloServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
        }
    }

    private static abstract class AbstractTestServlet
    extends HttpServlet {
        private AbstractTestServlet() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public List<String> captured = new ArrayList<String>();

        public void log(Request request, Response response) {
            int status = response.getCommittedMetaData().getStatus();
            this.captured.add(String.format("%s %s %s %03d", request.getMethod(), request.getRequestURI(), request.getProtocol(), status));
        }
    }
}

