/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.Config;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Monitor;

public class Main {
    private static final String START_LOG_FILENAME = "start.log";
    private static final SimpleDateFormat START_LOG_ROLLOVER_DATEFORMAT = new SimpleDateFormat("yyyy_MM_dd-HHmmSSSSS.'start.log'");
    private static final int EXIT_USAGE = 1;
    private static final int ERR_LOGGING = -1;
    private static final int ERR_INVOKE_MAIN = -2;
    private static final int ERR_NOT_STOPPED = -4;
    private static final int ERR_UNKNOWN = -5;
    private boolean _showUsage = false;
    private boolean _dumpVersions = false;
    private boolean _listConfig = false;
    private boolean _listOptions = false;
    private boolean _dryRun = false;
    private boolean _exec = false;
    private final Config _config = new Config();
    private final Set<String> _sysProps = new HashSet<String>();
    private final List<String> _jvmArgs = new ArrayList<String>();
    private String _startConfig = null;
    private String _jettyHome = new File(this._jettyHome).getCanonicalPath();

    public static void main(String[] args) {
        try {
            Main main = new Main();
            List<String> arguments = main.expandCommandLine(args);
            List<String> xmls = main.processCommandLine(arguments);
            if (xmls != null) {
                main.start(xmls);
            }
        }
        catch (Throwable e) {
            Main.usageExit(e, -5);
        }
    }

    Main() throws IOException {
    }

    public List<String> expandCommandLine(String[] args) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        boolean ini = false;
        for (String arg : args) {
            if (arg.startsWith("--ini=") || arg.equals("--ini")) {
                ini = true;
                if (arg.length() <= 6) continue;
                arguments.addAll(Main.loadStartIni(new File(arg.substring(6))));
                continue;
            }
            if (arg.startsWith("--config=")) {
                this._startConfig = arg.substring(9);
                continue;
            }
            arguments.add(arg);
        }
        if (!ini) {
            arguments.addAll(0, this.parseStartIniFiles());
        }
        return arguments;
    }

    List<String> parseStartIniFiles() {
        File start_d;
        ArrayList<String> ini_args = new ArrayList<String>();
        File start_ini = new File(this._jettyHome, "start.ini");
        if (start_ini.exists()) {
            ini_args.addAll(Main.loadStartIni(start_ini));
        }
        if ((start_d = new File(this._jettyHome, "start.d")).isDirectory()) {
            Object[] inis = start_d.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase(Locale.ENGLISH).endsWith(".ini");
                }
            });
            Arrays.sort(inis);
            for (Object i : inis) {
                ini_args.addAll(Main.loadStartIni((File)i));
            }
        }
        return ini_args;
    }

    public List<String> processCommandLine(List<String> arguments) throws Exception {
        ArrayList<String> xmls = new ArrayList<String>();
        int startup = 0;
        block8: for (String arg : arguments) {
            String[] assign;
            if ("--help".equals(arg) || "-?".equals(arg)) {
                this._showUsage = true;
                continue;
            }
            if ("--stop".equals(arg)) {
                int port = Integer.parseInt(Config.getProperty("STOP.PORT", "-1"));
                String key = Config.getProperty("STOP.KEY", null);
                int timeout = Integer.parseInt(Config.getProperty("STOP.WAIT", "0"));
                this.stop(port, key, timeout);
                return null;
            }
            if ("--version".equals(arg) || "-v".equals(arg) || "--info".equals(arg)) {
                this._dumpVersions = true;
                continue;
            }
            if ("--list-modes".equals(arg) || "--list-options".equals(arg)) {
                this._listOptions = true;
                continue;
            }
            if ("--list-config".equals(arg)) {
                this._listConfig = true;
                continue;
            }
            if ("--exec-print".equals(arg) || "--dry-run".equals(arg)) {
                this._dryRun = true;
                continue;
            }
            if ("--exec".equals(arg)) {
                this._exec = true;
                continue;
            }
            if ("--daemon".equals(arg)) {
                File startLog;
                File startDir = new File(System.getProperty("jetty.logs", "logs"));
                if (!startDir.exists() || !startDir.canWrite()) {
                    startDir = new File(".");
                }
                if (!(startLog = new File(startDir, START_LOG_ROLLOVER_DATEFORMAT.format(new Date()))).exists() && !startLog.createNewFile()) {
                    System.err.println("Unable to create: " + startLog.getAbsolutePath());
                    Main.usageExit(-1);
                }
                if (!startLog.canWrite()) {
                    System.err.println("Unable to write to: " + startLog.getAbsolutePath());
                    Main.usageExit(-1);
                }
                PrintStream logger = new PrintStream(new FileOutputStream(startLog, false));
                System.setOut(logger);
                System.setErr(logger);
                System.out.println("Establishing start.log on " + new Date());
                continue;
            }
            if (arg.startsWith("--pre=")) {
                xmls.add(startup++, arg.substring(6));
                continue;
            }
            if (arg.startsWith("-D")) {
                assign = arg.substring(2).split("=", 2);
                this._sysProps.add(assign[0]);
                switch (assign.length) {
                    case 2: {
                        System.setProperty(assign[0], assign[1]);
                        continue block8;
                    }
                    case 1: {
                        System.setProperty(assign[0], "");
                        continue block8;
                    }
                }
                continue;
            }
            if (arg.startsWith("-")) {
                this._jvmArgs.add(arg);
                continue;
            }
            if (arg.indexOf(61) >= 0) {
                assign = arg.split("=", 2);
                switch (assign.length) {
                    case 2: {
                        if ("OPTIONS".equals(assign[0])) {
                            String[] opts;
                            for (String opt : opts = assign[1].split(",")) {
                                this._config.addActiveOption(opt.trim());
                            }
                            continue block8;
                        }
                        this._config.setProperty(assign[0], assign[1]);
                        continue block8;
                    }
                    case 1: {
                        this._config.setProperty(assign[0], null);
                        continue block8;
                    }
                }
                continue;
            }
            if (xmls.contains(arg)) {
                System.out.println("WARN: Argument '" + arg + "' specified multiple times. Check start.ini?");
                System.out.println("Use \"java -jar start.jar --help\" for more information.");
            }
            xmls.add(arg);
        }
        return xmls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usage() {
        String usageResource = "org/eclipse/jetty/start/usage.txt";
        InputStream usageStream = this.getClass().getClassLoader().getResourceAsStream(usageResource);
        if (usageStream == null) {
            System.err.println("ERROR: detailed usage resource unavailable");
            Main.usageExit(1);
        }
        BufferedReader buf = null;
        try {
            String line;
            buf = new BufferedReader(new InputStreamReader(usageStream));
            while ((line = buf.readLine()) != null) {
                if (line.endsWith("@") && line.indexOf(64) != line.lastIndexOf(64)) {
                    String indent = line.substring(0, line.indexOf("@"));
                    String info = line.substring(line.indexOf(64), line.lastIndexOf(64));
                    if (info.equals("@OPTIONS")) {
                        ArrayList<String> sortedOptions = new ArrayList<String>();
                        sortedOptions.addAll(this._config.getSectionIds());
                        Collections.sort(sortedOptions);
                        for (String option : sortedOptions) {
                            if ("*".equals(option) || option.trim().length() == 0) continue;
                            System.out.print(indent);
                            System.out.println(option);
                        }
                        continue;
                    }
                    if (info.equals("@CONFIGS")) {
                        File etc = new File(System.getProperty("jetty.home", "."), "etc");
                        if (!etc.exists() || !etc.isDirectory()) {
                            System.out.print(indent);
                            System.out.println("Unable to find/list " + etc);
                            continue;
                        }
                        File[] configs = etc.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File path) {
                                if (!path.isFile()) {
                                    return false;
                                }
                                String name = path.getName().toLowerCase(Locale.ENGLISH);
                                return name.startsWith("jetty") && name.endsWith(".xml");
                            }
                        });
                        ArrayList<File> configFiles = new ArrayList<File>();
                        configFiles.addAll(Arrays.asList(configs));
                        Collections.sort(configFiles);
                        for (File configFile : configFiles) {
                            System.out.print(indent);
                            System.out.print("etc/");
                            System.out.println(configFile.getName());
                        }
                        continue;
                    }
                    if (!info.equals("@STARTINI")) continue;
                    List<String> ini = Main.loadStartIni(new File(this._jettyHome, "start.ini"));
                    if (ini != null && ini.size() > 0) {
                        for (String a : ini) {
                            System.out.print(indent);
                            System.out.println(a);
                        }
                        continue;
                    }
                    System.out.print(indent);
                    System.out.println("none");
                    continue;
                }
                System.out.println(line);
            }
        }
        catch (IOException e) {
            try {
                Main.usageExit(e, 1);
            }
            catch (Throwable throwable) {
                Main.close(buf);
                throw throwable;
            }
            Main.close(buf);
        }
        Main.close(buf);
        System.exit(1);
    }

    public void invokeMain(ClassLoader classloader, String classname, List<String> args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = null;
        try {
            invoked_class = classloader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (Config.isDebug() || invoked_class == null) {
            if (invoked_class == null) {
                System.err.println("ClassNotFound: " + classname);
            } else {
                System.err.println(classname + " " + invoked_class.getPackage().getImplementationVersion());
            }
            if (invoked_class == null) {
                Main.usageExit(-2);
                return;
            }
        }
        String[] argArray = args.toArray(new String[0]);
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        main.invoke(null, method_params);
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public void start(List<String> xmls) throws IOException, InterruptedException {
        int port = Integer.parseInt(Config.getProperty("STOP.PORT", "-1"));
        String key = Config.getProperty("STOP.KEY", null);
        Monitor monitor = new Monitor(port, key);
        List<String> configuredXmls = this.loadConfig(xmls);
        if (configuredXmls.isEmpty()) {
            throw new FileNotFoundException("No XML configuration files specified in start.config or command line.");
        }
        configuredXmls = this.resolveXmlConfigs(configuredXmls);
        Classpath classpath = this._config.getActiveClasspath();
        System.setProperty("java.class.path", classpath.toString());
        ClassLoader cl = classpath.getClassLoader();
        if (Config.isDebug()) {
            System.err.println("java.class.path=" + System.getProperty("java.class.path"));
            System.err.println("jetty.home=" + System.getProperty("jetty.home"));
            System.err.println("java.home=" + System.getProperty("java.home"));
            System.err.println("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
            System.err.println("java.class.path=" + classpath);
            System.err.println("classloader=" + cl);
            System.err.println("classloader.parent=" + cl.getParent());
            System.err.println("properties=" + Config.getProperties());
        }
        if (this._showUsage) {
            this.usage();
            return;
        }
        if (this._dumpVersions) {
            this.showClasspathWithVersions(classpath);
            return;
        }
        if (this._listOptions) {
            this.showAllOptionsWithVersions();
            return;
        }
        if (this._listConfig) {
            this.listConfig();
            return;
        }
        if (this._dryRun) {
            CommandLineBuilder cmd = this.buildCommandLine(classpath, configuredXmls);
            System.out.println(cmd.toString());
            return;
        }
        if (this._exec) {
            CommandLineBuilder cmd = this.buildCommandLine(classpath, configuredXmls);
            ProcessBuilder pbuilder = new ProcessBuilder(cmd.getArgs());
            final Process process = pbuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Config.debug("Destroying " + process);
                    process.destroy();
                }
            });
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            monitor.setProcess(process);
            process.waitFor();
            return;
        }
        if (this._jvmArgs.size() > 0 || this._sysProps.size() > 0) {
            System.err.println("WARNING: System properties and/or JVM args set.  Consider using --dry-run or --exec");
        }
        Thread.currentThread().setContextClassLoader(cl);
        try {
            String classname = this._config.getMainClassname();
            String mainClass = System.getProperty("jetty.server");
            if (mainClass != null) {
                classname = mainClass;
            }
            if ((mainClass = System.getProperty("main.class")) != null) {
                classname = mainClass;
            }
            Config.debug("main.class=" + classname);
            this.invokeMain(cl, classname, configuredXmls);
        }
        catch (Exception e) {
            Main.usageExit(e, -2);
        }
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private String resolveXmlConfig(String xmlFilename) throws FileNotFoundException {
        if (!xmlFilename.toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
            return xmlFilename;
        }
        File xml = new File(xmlFilename);
        if (xml.exists() && xml.isFile()) {
            return xml.getAbsolutePath();
        }
        xml = new File(this._jettyHome, this.fixPath(xmlFilename));
        if (xml.exists() && xml.isFile()) {
            return xml.getAbsolutePath();
        }
        xml = new File(this._jettyHome, this.fixPath("etc/" + xmlFilename));
        if (xml.exists() && xml.isFile()) {
            return xml.getAbsolutePath();
        }
        throw new FileNotFoundException("Unable to find XML Config: " + xmlFilename);
    }

    CommandLineBuilder buildCommandLine(Classpath classpath, List<String> xmls) throws IOException {
        CommandLineBuilder cmd = new CommandLineBuilder(this.findJavaBin());
        for (String x : this._jvmArgs) {
            cmd.addArg(x);
        }
        cmd.addRawArg("-Djetty.home=" + this._jettyHome);
        for (String p : this._sysProps) {
            String v = System.getProperty(p);
            cmd.addEqualsArg("-D" + p, v);
        }
        cmd.addArg("-cp");
        cmd.addRawArg(classpath.toString());
        cmd.addRawArg(this._config.getMainClassname());
        Properties properties = Config.getProperties();
        if (properties.size() > 0) {
            File prop_file = File.createTempFile("start", ".properties");
            if (!this._dryRun) {
                prop_file.deleteOnExit();
            }
            properties.store(new FileOutputStream(prop_file), "start.jar properties");
            cmd.addArg(prop_file.getAbsolutePath());
        }
        for (String xml : xmls) {
            cmd.addRawArg(xml);
        }
        return cmd;
    }

    private String findJavaBin() {
        File javaHome = new File(System.getProperty("java.home"));
        if (!javaHome.exists()) {
            return null;
        }
        File javabin = this.findExecutable(javaHome, "bin/java");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        javabin = this.findExecutable(javaHome, "bin/java.exe");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    private File findExecutable(File root, String path) {
        String npath = path.replace('/', File.separatorChar);
        File exe = new File(root, npath);
        if (!exe.exists()) {
            return null;
        }
        return exe;
    }

    private void showAllOptionsWithVersions() {
        Set<String> sectionIds = this._config.getSectionIds();
        StringBuffer msg = new StringBuffer();
        msg.append("There ");
        if (sectionIds.size() > 1) {
            msg.append("are ");
        } else {
            msg.append("is ");
        }
        msg.append(String.valueOf(sectionIds.size()));
        msg.append(" OPTION");
        if (sectionIds.size() > 1) {
            msg.append("s");
        }
        msg.append(" available to use.");
        System.out.println(msg);
        System.out.println("Each option is listed along with associated available classpath entries,  in the order that they would appear from that mode.");
        System.out.println("Note: If using multiple options (eg: 'Server,servlet,webapp,jms,jmx') then overlapping entries will not be repeated in the eventual classpath.");
        System.out.println();
        System.out.printf("${jetty.home} = %s%n", this._jettyHome);
        System.out.println();
        for (String sectionId : sectionIds) {
            if ("".equals(sectionId)) {
                System.out.println("GLOBAL option (Prepended Entries)");
            } else if ("*".equals(sectionId)) {
                System.out.println("GLOBAL option (Appended Entries) (*)");
            } else {
                System.out.printf("Option [%s]", sectionId);
                if (Character.isUpperCase(sectionId.charAt(0))) {
                    System.out.print(" (Aggregate)");
                }
                System.out.println();
            }
            System.out.println("-------------------------------------------------------------");
            Classpath sectionCP = this._config.getSectionClasspath(sectionId);
            if (sectionCP.isEmpty()) {
                System.out.println("Empty option, no classpath entries active.");
                System.out.println();
                continue;
            }
            int i = 0;
            for (File element : sectionCP.getElements()) {
                String elementPath = element.getAbsolutePath();
                if (elementPath.startsWith(this._jettyHome)) {
                    elementPath = "${jetty.home}" + elementPath.substring(this._jettyHome.length());
                }
                System.out.printf("%2d: %20s | %s\n", i++, this.getVersion(element), elementPath);
            }
            System.out.println();
        }
    }

    private void showClasspathWithVersions(Classpath classpath) {
        System.out.println("Active Options: " + this._config.getActiveOptions());
        if (classpath.count() == 0) {
            System.out.println("No version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the OPTIONS=[option,option,...] command line option will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            String elementPath = element.getAbsolutePath();
            if (elementPath.startsWith(this._jettyHome)) {
                elementPath = "${jetty.home}" + elementPath.substring(this._jettyHome.length());
            }
            System.out.printf("%2d: %20s | %s\n", i++, this.getVersion(element), elementPath);
        }
    }

    private String fixPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    private String getVersion(File element) {
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile()) {
            String name = element.getName().toLowerCase(Locale.ENGLISH);
            if (name.endsWith(".jar")) {
                return JarVersion.getVersion(element);
            }
            if (name.endsWith(".zip")) {
                return this.getZipVersion(element);
            }
        }
        return "";
    }

    private String getZipVersion(File element) {
        return "";
    }

    private List<String> resolveXmlConfigs(List<String> xmls) throws FileNotFoundException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String xml : xmls) {
            ret.add(this.resolveXmlConfig(xml));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listConfig() {
        InputStream cfgstream = null;
        try {
            cfgstream = this.getConfigStream();
            byte[] buf = new byte[4096];
            int len = 0;
            while (len >= 0) {
                len = cfgstream.read(buf);
                if (len <= 0) continue;
                System.out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            Main.usageExit(e, -5);
        }
        finally {
            Main.close(cfgstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadConfig(List<String> xmls) {
        ArrayList<String> arrayList;
        InputStream cfgstream = null;
        try {
            this._config.setArgCount(xmls.size());
            cfgstream = this.getConfigStream();
            this._config.parse(cfgstream);
            this._jettyHome = Config.getProperty("jetty.home", this._jettyHome);
            if (this._jettyHome != null) {
                this._jettyHome = new File(this._jettyHome).getCanonicalPath();
                System.setProperty("jetty.home", this._jettyHome);
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.addAll(xmls);
            for (String xmlconfig : this._config.getXmlConfigs()) {
                if (ret.contains(xmlconfig)) continue;
                ret.add(xmlconfig);
            }
            arrayList = ret;
        }
        catch (Exception e) {
            List<String> list;
            try {
                Main.usageExit(e, -5);
                list = null;
            }
            catch (Throwable throwable) {
                Main.close(cfgstream);
                throw throwable;
            }
            Main.close(cfgstream);
            return list;
        }
        Main.close(cfgstream);
        return arrayList;
    }

    private InputStream getConfigStream() throws FileNotFoundException {
        String config = this._startConfig;
        if (config == null || config.length() == 0) {
            config = System.getProperty("START", "org/eclipse/jetty/start/start.config");
        }
        Config.debug("config=" + config);
        InputStream cfgstream = this.getClass().getClassLoader().getResourceAsStream(config);
        if (cfgstream == null) {
            cfgstream = new FileInputStream(config);
        }
        return cfgstream;
    }

    public void stop(int port, String key) {
        this.stop(port, key, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int port, String key, int timeout) {
        int _port = port;
        String _key = key;
        try {
            if (_port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (_key == null) {
                _key = "";
                System.err.println("STOP.KEY system property must be specified");
                System.err.println("Using empty key");
            }
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), _port);
            if (timeout > 0) {
                s.setSoTimeout(timeout * 1000);
            }
            try {
                OutputStream out = s.getOutputStream();
                out.write((_key + "\r\nstop\r\n").getBytes());
                out.flush();
                if (timeout > 0) {
                    System.err.println("Waiting" + (timeout > 0 ? " " + timeout + "sec" : "") + " for jetty to stop");
                    LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                    String response = lin.readLine();
                    if ("Stopped".equals(response)) {
                        System.err.println("Stopped");
                    }
                }
            }
            finally {
                s.close();
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timed out waiting for stop confirmation");
            System.exit(-5);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4);
        }
        catch (Exception e) {
            Main.usageExit(e, -5);
        }
    }

    static void usageExit(Throwable t, int exit) {
        t.printStackTrace(System.err);
        System.err.println();
        System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
        System.err.println("       java -jar start.jar --help  # for more information");
        System.exit(exit);
    }

    static void usageExit(int exit) {
        System.err.println();
        System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
        System.err.println("       java -jar start.jar --help  # for more information");
        System.exit(exit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> loadStartIni(File ini) {
        ArrayList<String> args;
        block7: {
            if (!ini.exists()) {
                System.err.println("Warning - can't find ini file: " + ini);
                return Collections.emptyList();
            }
            args = new ArrayList<String>();
            FileReader reader = null;
            BufferedReader buf = null;
            try {
                String arg;
                reader = new FileReader(ini);
                buf = new BufferedReader(reader);
                while ((arg = buf.readLine()) != null) {
                    if ((arg = arg.trim()).length() == 0 || arg.startsWith("#")) continue;
                    args.add(arg);
                }
                Main.close(buf);
            }
            catch (IOException e) {
                Main.usageExit(e, -5);
                break block7;
            }
            finally {
                Main.close(buf);
                Main.close(reader);
            }
            Main.close(reader);
        }
        return args;
    }

    void addJvmArgs(List<String> jvmArgs) {
        this._jvmArgs.addAll(jvmArgs);
    }
}

