/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.StartLog;

public class TextFile
implements Iterable<String> {
    private final File file;
    private final List<String> lines = new ArrayList<String>();

    public TextFile(File file) throws FileNotFoundException, IOException {
        this.file = file;
        this.init();
        if (!FS.canReadFile(file)) {
            StartLog.debug("Skipping read of missing file: %s", file.getAbsolutePath());
            return;
        }
        try (FileReader reader = new FileReader(file);
             BufferedReader buf = new BufferedReader(reader);){
            String line;
            while ((line = buf.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                this.process(line.trim());
            }
        }
    }

    public void addUniqueLine(String line) {
        if (this.lines.contains(line)) {
            return;
        }
        this.lines.add(line);
    }

    public File getFile() {
        return this.file;
    }

    public List<String> getLineMatches(Pattern pattern) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String line : this.lines) {
            if (!pattern.matcher(line).matches()) continue;
            ret.add(line);
        }
        return ret;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void init() {
    }

    @Override
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    public ListIterator<String> listIterator() {
        return this.lines.listIterator();
    }

    public void process(String line) {
        this.addUniqueLine(line);
    }
}

