/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CRL;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateValidator {
    private KeyStore _trustStore;
    private Collection<? extends CRL> _crls;
    private int _maxCertPathLength = -1;

    public CertificateValidator(KeyStore trustStore, Collection<? extends CRL> crls) {
        this._trustStore = trustStore;
        this._crls = crls;
    }

    public void validate(KeyStore keyStore) throws CertificateException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.validate(keyStore, alias);
            }
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("error obtaining aliases", kse);
        }
    }

    public String validate(KeyStore keyStore, String keyAlias) throws CertificateException {
        String result = null;
        if (keyAlias != null) {
            try {
                this.validate(keyStore, keyStore.getCertificate(keyAlias));
            }
            catch (KeyStoreException ex) {
                Log.debug(ex);
                throw new CertificateException("Unable to validate certificate for alias [" + keyAlias + "]: " + ex.getMessage());
            }
            result = keyAlias;
        }
        return result;
    }

    public void validate(KeyStore keyStore, Certificate cert) throws CertificateException {
        if (cert != null && cert instanceof X509Certificate) {
            ((X509Certificate)cert).checkValidity();
            String certAlias = "[none]";
            try {
                certAlias = keyStore.getCertificateAlias((X509Certificate)cert);
                Certificate[] certChain = keyStore.getCertificateChain(certAlias);
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                for (Certificate item : certChain) {
                    if (!(item instanceof X509Certificate)) {
                        throw new CertificateException("Invalid certificate type in chain");
                    }
                    certList.add((X509Certificate)item);
                }
                if (certList.isEmpty()) {
                    throw new CertificateException("Invalid certificate chain");
                }
                X509CertSelector certSelect = new X509CertSelector();
                certSelect.setCertificate((X509Certificate)certList.get(0));
                PKIXBuilderParameters pbParams = new PKIXBuilderParameters(this._trustStore, (CertSelector)certSelect);
                pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(certList)));
                if (this._crls != null && !this._crls.isEmpty()) {
                    pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(this._crls)));
                }
                pbParams.setRevocationEnabled(true);
                pbParams.setMaxPathLength(this._maxCertPathLength);
                CertPathBuilderResult buildResult = CertPathBuilder.getInstance("PKIX").build(pbParams);
                CertPathValidator.getInstance("PKIX").validate(buildResult.getCertPath(), pbParams);
            }
            catch (Exception ex) {
                Log.debug(ex);
                throw new CertificateException("Unable to validate certificate for alias [" + certAlias + "]: " + ex.getMessage());
            }
        }
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int maxCertPathLength) {
        this._maxCertPathLength = maxCertPathLength;
    }

    public KeyStore getTrustStore() {
        return this._trustStore;
    }

    public Collection<? extends CRL> getCrls() {
        return this._crls;
    }
}

