/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppClassLoader
extends URLClassLoader {
    private final Context _context;
    private final ClassLoader _parent;
    private final Set<String> _extensions = new HashSet<String>();
    private String _name = String.valueOf(this.hashCode());

    public WebAppClassLoader(Context context) throws IOException {
        this(null, context);
    }

    public WebAppClassLoader(ClassLoader parent, Context context) throws IOException {
        super(new URL[]{}, parent != null ? parent : (Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : (WebAppClassLoader.class.getClassLoader() != null ? WebAppClassLoader.class.getClassLoader() : ClassLoader.getSystemClassLoader())));
        this._parent = this.getParent();
        this._context = context;
        if (this._parent == null) {
            throw new IllegalArgumentException("no parent classloader!");
        }
        this._extensions.add(".jar");
        this._extensions.add(".zip");
        String extensions = System.getProperty(WebAppClassLoader.class.getName() + ".extensions");
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, ",;");
            while (tokenizer.hasMoreTokens()) {
                this._extensions.add(tokenizer.nextToken().trim());
            }
        }
        if (context.getExtraClasspath() != null) {
            this.addClassPath(context.getExtraClasspath());
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Context getContext() {
        return this._context;
    }

    public void addClassPath(Resource resource) throws IOException {
        if (resource instanceof ResourceCollection) {
            for (Resource r : ((ResourceCollection)resource).getResources()) {
                this.addClassPath(r);
            }
        } else {
            this.addClassPath(resource.toString());
        }
    }

    public void addClassPath(String classPath) throws IOException {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, ",;");
        while (tokenizer.hasMoreTokens()) {
            Resource resource = this._context.newResource(tokenizer.nextToken());
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Path resource=" + resource));
            }
            if (resource.isDirectory() && resource instanceof ResourceCollection) {
                this.addClassPath(resource);
                continue;
            }
            File file = resource.getFile();
            if (file != null) {
                URL url = resource.getURL();
                this.addURL(url);
                continue;
            }
            if (resource.isDirectory()) {
                this.addURL(resource.getURL());
                continue;
            }
            throw new IllegalArgumentException("!file: " + resource);
        }
    }

    private boolean isFileSupported(String file) {
        int dot = file.lastIndexOf(46);
        return dot != -1 && this._extensions.contains(file.substring(dot));
    }

    public void addJars(Resource lib) {
        if (lib.exists() && lib.isDirectory()) {
            String[] files = lib.list();
            for (int f = 0; files != null && f < files.length; ++f) {
                try {
                    Resource fn = lib.addPath(files[f]);
                    String fnlc = fn.getName().toLowerCase();
                    if (fn.isDirectory() || !this.isFileSupported(fnlc)) continue;
                    String jar = fn.toString();
                    jar = StringUtil.replace((String)jar, (String)",", (String)"%2C");
                    jar = StringUtil.replace((String)jar, (String)";", (String)"%3B");
                    this.addClassPath(jar);
                    continue;
                }
                catch (Exception ex) {
                    Log.warn((String)"EXCEPTION ", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection permissions = this._context.getPermissions();
        PermissionCollection pc = permissions == null ? super.getPermissions(cs) : permissions;
        return pc;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        List<URL> from_parent = this.toList(server_class ? null : this._parent.getResources(name));
        List<URL> from_webapp = this.toList((Enumeration<URL>)(system_class && !from_parent.isEmpty() ? null : this.findResources(name)));
        if (this._context.isParentLoaderPriority()) {
            from_parent.addAll(from_webapp);
            return Collections.enumeration(from_parent);
        }
        from_webapp.addAll(from_parent);
        return Collections.enumeration(from_webapp);
    }

    private List<URL> toList(Enumeration<URL> e) {
        ArrayList<URL> list = new ArrayList<URL>();
        while (e != null && e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean tried_parent = false;
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        if (system_class && server_class) {
            return null;
        }
        if (this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
            tried_parent = true;
            if (this._parent != null) {
                url = this._parent.getResource(name);
            }
        }
        if (url == null && (url = this.findResource(name)) == null && name.startsWith("/")) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("HACK leading / off " + name));
            }
            url = this.findResource(name.substring(1));
        }
        if (url == null && !tried_parent && !server_class && this._parent != null) {
            url = this._parent.getResource(name);
        }
        if (url != null && Log.isDebugEnabled()) {
            Log.debug((String)("getResource(" + name + ")=" + url));
        }
        return url;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        ClassNotFoundException ex = null;
        boolean tried_parent = false;
        boolean system_class = this._context.isSystemClass(name);
        boolean server_class = this._context.isServerClass(name);
        if (system_class && server_class) {
            return null;
        }
        if (c == null && this._parent != null && (this._context.isParentLoaderPriority() || system_class) && !server_class) {
            tried_parent = true;
            try {
                c = this._parent.loadClass(name);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("loaded " + c));
                }
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null && this._parent != null && !tried_parent && !server_class) {
            c = this._parent.loadClass(name);
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("loaded " + c + " from " + c.getClassLoader()));
        }
        return c;
    }

    public String toString() {
        return "WebAppClassLoader=" + this._name + "@" + Long.toHexString(this.hashCode());
    }

    public static interface Context {
        public Resource newResource(String var1) throws IOException;

        public PermissionCollection getPermissions();

        public boolean isSystemClass(String var1);

        public boolean isServerClass(String var1);

        public boolean isParentLoaderPriority();

        public String getExtraClasspath();
    }
}

