/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.warurl.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;

public class WarURLConnection
extends URLConnection {
    private Manifest _mf;
    private URLConnection _conn;

    public static InputStream substitueManifest(final Manifest newmanifest, final InputStream rawIn) throws IOException {
        final PipedOutputStream pOut = new PipedOutputStream();
        PipedInputStream pIn = new PipedInputStream(pOut);
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block11: {
                    JarInputStream jin;
                    block10: {
                        jin = null;
                        JarOutputStream dest = null;
                        try {
                            jin = new JarInputStream(rawIn, false);
                            dest = new JarOutputStream((OutputStream)pOut, newmanifest);
                            ZipEntry next = jin.getNextEntry();
                            while (next != null) {
                                if (next.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                                dest.putNextEntry(next);
                                if (next.getSize() > 0L) {
                                    IO.copy((InputStream)jin, (OutputStream)dest, (long)next.getSize());
                                }
                                next = jin.getNextJarEntry();
                            }
                            if (dest == null) break block10;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            break block11;
                        }
                        finally {
                            if (dest != null) {
                                IO.close(dest);
                            }
                            if (jin != null) {
                                IO.close((InputStream)jin);
                            }
                            IO.close((OutputStream)pOut);
                        }
                        IO.close((OutputStream)dest);
                    }
                    if (jin != null) {
                        IO.close((InputStream)jin);
                    }
                    IO.close((OutputStream)pOut);
                }
            }
        };
        Thread th = new Thread(run);
        th.start();
        return pIn;
    }

    public WarURLConnection(URL url, Manifest mf) throws IOException {
        super(url);
        this._conn = url.openConnection();
        this._conn.setDefaultUseCaches(Resource.getDefaultUseCaches());
        this._mf = mf;
    }

    @Override
    public void connect() throws IOException {
        this._conn.connect();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return WarURLConnection.substitueManifest(this._mf, this._conn.getInputStream());
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this._conn.addRequestProperty(key, value);
    }

    public boolean equals(Object obj) {
        return this._conn.equals(obj);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this._conn.getAllowUserInteraction();
    }

    @Override
    public int getConnectTimeout() {
        return this._conn.getConnectTimeout();
    }

    @Override
    public Object getContent() throws IOException {
        return this._conn.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this._conn.getContent(classes);
    }

    @Override
    public String getContentEncoding() {
        return this._conn.getContentEncoding();
    }

    @Override
    public int getContentLength() {
        return this._conn.getContentLength();
    }

    @Override
    public String getContentType() {
        return this._conn.getContentType();
    }

    @Override
    public long getDate() {
        return this._conn.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this._conn.getDefaultUseCaches();
    }

    @Override
    public boolean getDoInput() {
        return this._conn.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this._conn.getDoOutput();
    }

    @Override
    public long getExpiration() {
        return this._conn.getExpiration();
    }

    @Override
    public String getHeaderField(int n) {
        return this._conn.getHeaderField(n);
    }

    @Override
    public String getHeaderField(String name) {
        return this._conn.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return this._conn.getHeaderFieldDate(name, Default);
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return this._conn.getHeaderFieldInt(name, Default);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this._conn.getHeaderFieldKey(n);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this._conn.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this._conn.getIfModifiedSince();
    }

    @Override
    public long getLastModified() {
        return this._conn.getLastModified();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._conn.getOutputStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this._conn.getPermission();
    }

    @Override
    public int getReadTimeout() {
        return this._conn.getReadTimeout();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this._conn.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this._conn.getRequestProperty(key);
    }

    @Override
    public URL getURL() {
        return this._conn.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this._conn.getUseCaches();
    }

    @Override
    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this._conn.setAllowUserInteraction(allowuserinteraction);
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this._conn.setConnectTimeout(timeout);
    }

    @Override
    public void setDefaultUseCaches(boolean defaultusecaches) {
        this._conn.setDefaultUseCaches(defaultusecaches);
    }

    @Override
    public void setDoInput(boolean doinput) {
        this._conn.setDoInput(doinput);
    }

    @Override
    public void setDoOutput(boolean dooutput) {
        this._conn.setDoOutput(dooutput);
    }

    @Override
    public void setIfModifiedSince(long ifmodifiedsince) {
        this._conn.setIfModifiedSince(ifmodifiedsince);
    }

    @Override
    public void setReadTimeout(int timeout) {
        this._conn.setReadTimeout(timeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this._conn.setRequestProperty(key, value);
    }

    @Override
    public void setUseCaches(boolean usecaches) {
        this._conn.setUseCaches(usecaches);
    }
}

