/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xslt.tools;

import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jetty.xslt.tools.AbstractFetchException;

public class JavaSourceFetchExtension
extends AbstractFetchException {
    public static String fetch(String location, String method) throws Exception {
        CompilationUnit cu;
        File fetchFile = JavaSourceFetchExtension.checkCache(location);
        if (fetchFile == null) {
            URL url = new URL(location);
            fetchFile = JavaSourceFetchExtension.cache(location, url.openStream());
        }
        if (method == null || "".equals(method)) {
            cu = JavaParser.parse((InputStream)new FileInputStream(fetchFile));
            return cu.toString();
        }
        cu = JavaParser.parse((InputStream)new FileInputStream(fetchFile));
        MethodVisitor mv = new MethodVisitor(method);
        mv.visit(cu, null);
        return mv.source;
    }

    private static class MethodVisitor
    extends VoidVisitorAdapter {
        String methodName;
        String source;

        MethodVisitor(String methodName) {
            this.methodName = methodName;
        }

        public void visit(MethodDeclaration n, Object arg) {
            if (this.methodName.equals(n.getName())) {
                this.source = n.toString();
            }
        }
    }
}

