/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
    private final WebSocketExtensionFactory extensionRegistry;
    private final EventDriverFactory eventDriverFactory;
    private final SessionFactory sessionFactory;
    private final DecoratedObjectFactory objectFactory;
    private Masker masker;
    private final int id = ThreadLocalRandom.current().nextInt();

    public WebSocketClient() {
        this(new HttpClient());
        this.addBean(this.httpClient);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, new DecoratedObjectFactory());
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory objectFactory) {
        this.httpClient = httpClient;
        this.objectFactory = objectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory((WebSocketContainerScope)this);
        this.masker = new RandomMasker();
        this.eventDriverFactory = new EventDriverFactory(this.policy);
        this.sessionFactory = new WebSocketSessionFactory((WebSocketContainerScope)this);
    }

    @Deprecated
    public WebSocketClient(Executor executor) {
        this(null, executor);
    }

    @Deprecated
    public WebSocketClient(ByteBufferPool bufferPool) {
        this(null, null, bufferPool);
    }

    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(sslContextFactory, executor, (ByteBufferPool)new MappedByteBufferPool());
    }

    public WebSocketClient(WebSocketContainerScope scope) {
        this(scope.getSslContextFactory(), scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(WebSocketContainerScope scope, SslContextFactory sslContextFactory) {
        this(sslContextFactory, scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        this(sslContextFactory, executor, bufferPool, new DecoratedObjectFactory());
    }

    private WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this.httpClient = new HttpClient(sslContextFactory);
        this.httpClient.setExecutor(executor);
        this.httpClient.setByteBufferPool(bufferPool);
        this.addBean(this.httpClient);
        this.objectFactory = objectFactory == null ? new DecoratedObjectFactory() : objectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory((WebSocketContainerScope)this);
        this.masker = new RandomMasker();
        this.eventDriverFactory = new EventDriverFactory(this.policy);
        this.sessionFactory = new WebSocketSessionFactory((WebSocketContainerScope)this);
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory) {
        SslContextFactory sslContextFactory = scope.getSslContextFactory();
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory();
        }
        this.httpClient = new HttpClient(sslContextFactory);
        this.httpClient.setExecutor(scope.getExecutor());
        this.addBean(this.httpClient);
        this.objectFactory = new DecoratedObjectFactory();
        this.extensionRegistry = new WebSocketExtensionFactory((WebSocketContainerScope)this);
        this.masker = new RandomMasker();
        this.eventDriverFactory = eventDriverFactory;
        this.sessionFactory = sessionFactory;
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + ((Object)((Object)this)).hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank((String)toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", new Object[]{websocket, toUri});
        }
        this.init();
        WebSocketUpgradeRequest wsReq = new WebSocketUpgradeRequest(this, this.httpClient, request);
        wsReq.setUpgradeListener(upgradeListener);
        return wsReq.sendAsync();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", new Object[]{this});
        }
        if (ShutdownThread.isRegistered((LifeCycle)this)) {
            ShutdownThread.deregister((LifeCycle)this);
        }
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", new Object[]{this});
        }
    }

    @Deprecated
    public boolean isDispatchIO() {
        return this.httpClient.isDispatchIO();
    }

    public long getAsyncWriteTimeout() {
        return this.policy.getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.httpClient.getBindAddress();
    }

    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    @Deprecated
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public long getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public CookieStore getCookieStore() {
        return this.httpClient.getCookieStore();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.policy.getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.policy.getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.policy.getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.policy.getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.policy.getMaxTextMessageSize();
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(new HashSet(this.getBeans(WebSocketSession.class)));
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    private synchronized void init() throws IOException {
        if (!ShutdownThread.isRegistered((LifeCycle)this)) {
            ShutdownThread.register((LifeCycle[])new LifeCycle[]{this});
        }
    }

    @Deprecated
    protected ConnectionManager newConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public void onSessionClosed(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Closed: {}", new Object[]{session});
        }
        this.removeBean(session);
    }

    public void onSessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", new Object[]{session});
        }
        this.addManaged((LifeCycle)session);
        LOG.debug("post-onSessionOpened() - {}", new Object[]{this});
    }

    public void setAsyncWriteTimeout(long ms) {
        this.policy.setAsyncWriteTimeout(ms);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress bindAddress) {
        this.setBindAddress(bindAddress);
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.httpClient.setBindAddress(bindAddress);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.httpClient.setByteBufferPool(bufferPool);
    }

    public void setConnectTimeout(long ms) {
        this.httpClient.setConnectTimeout(ms);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpClient.setCookieStore(cookieStore);
    }

    public void setDaemon(boolean daemon) {
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
        this.httpClient.setDispatchIO(dispatchIO);
    }

    public void setExecutor(Executor executor) {
        this.httpClient.setExecutor(executor);
    }

    public void setMasker(Masker masker) {
        this.masker = masker;
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.policy.setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.policy.setIdleTimeout(ms);
        this.httpClient.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.policy.setMaxTextMessageBufferSize(max);
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        WebSocketClient.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{this.getOpenSessions()});
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.id));
        sb.append("[httpClient=").append(this.httpClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

