/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.decoders;

import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jetty.websocket.jakarta.common.InitException;

public class RegisteredDecoder {
    public final Class<? extends Decoder> decoder;
    public final Class<? extends Decoder> interfaceType;
    public final Class<?> objectType;
    public final boolean primitive;
    public final EndpointConfig config;
    private Decoder instance;

    public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType, EndpointConfig endpointConfig) {
        this(decoder, interfaceType, objectType, endpointConfig, false);
    }

    public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType, EndpointConfig endpointConfig, boolean primitive) {
        this.decoder = decoder;
        this.interfaceType = interfaceType;
        this.objectType = objectType;
        this.primitive = primitive;
        this.config = endpointConfig;
    }

    public boolean implementsInterface(Class<? extends Decoder> type) {
        return this.interfaceType.isAssignableFrom(type);
    }

    public boolean isType(Class<?> type) {
        return this.objectType.isAssignableFrom(type);
    }

    public <T extends Decoder> T getInstance() {
        if (this.instance == null) {
            try {
                this.instance = this.decoder.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.instance.init(this.config);
                return (T)this.instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new InitException("Unable to init Decoder for type:" + this.decoder.getName(), e);
            }
        }
        return (T)this.instance;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(RegisteredDecoder.class.getSimpleName());
        str.append('[').append(this.decoder.getName());
        str.append(',').append(this.interfaceType.getName());
        str.append(',').append(this.objectType.getName());
        if (this.primitive) {
            str.append(",PRIMITIVE");
        }
        str.append(']');
        return str.toString();
    }
}

