/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.util.Locale;
import org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import org.junit.Assert;
import org.junit.Test;

public class BouncyCastleGpgKeyLocatorTest {
    private static final String USER_ID = "Heinrich Heine <heinrichh@uni-duesseldorf.de>";

    private static boolean match(String userId, String pattern) {
        return BouncyCastleGpgKeyLocator.containsSigningKey((String)userId, (String)pattern);
    }

    @Test
    public void testFullMatch() throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "=Heinrich Heine <heinrichh@uni-duesseldorf.de>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "=Heinrich Heine"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "= "));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "=heinrichh@uni-duesseldorf.de"));
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, ""));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, null));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", ""));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(null, ""));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(null, null));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "something"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(null, "something"));
    }

    @Test
    public void testFullEmail() throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<heinrichh@uni-duesseldorf.de>"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("Heinrich Heine <heinrichh@uni-duesseldorf.de> ", "<heinrichh@uni-duesseldorf.de>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<h>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<heinrichh>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<uni-duesseldorf>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<h@u>"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "<HeinrichH@uni-duesseldorf.de>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID.substring(0, USER_ID.length() - 1), "<heinrichh@uni-duesseldorf.de>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "<>"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "<heinrichh@uni-duesseldorf.de>"));
    }

    @Test
    public void testPartialEmail() throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@heinrichh@uni-duesseldorf.de"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@heinrichh"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@duesseldorf"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@uni-d"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@h"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@."));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@h@u"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@ "));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@Heine"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@HeinrichH"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, "@Heinrich"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "@"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "@h"));
    }

    private void substringTests(String prefix) throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "heinrichh@uni-duesseldorf.de"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "heinrich"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "HEIN"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "Heine <"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "UNI"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "uni"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "rich He"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "h@u"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + USER_ID));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + USER_ID.toUpperCase(Locale.ROOT)));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix)));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + " "));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match(USER_ID, String.valueOf(prefix) + "yy"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", String.valueOf(prefix)));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", String.valueOf(prefix) + "uni"));
    }

    @Test
    public void testSubstringPlain() throws Exception {
        this.substringTests("");
    }

    @Test
    public void testSubstringAsterisk() throws Exception {
        this.substringTests("*");
    }

    @Test
    public void testExplicitFingerprint() throws Exception {
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <j.fade@example.com>", "0xfade"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "0xfade"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "0xFADE"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "0xfade"));
    }

    @Test
    public void testImplicitFingerprint() throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <j.fade@example.com>", "fade"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "fade"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <j.fade@example.com>", "FADE"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "FADE"));
    }

    @Test
    public void testZeroX() throws Exception {
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "0x"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "*0x"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "*0xfade"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "*0xFADE"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "@0xfade"));
        Assert.assertTrue((boolean)BouncyCastleGpgKeyLocatorTest.match("John Fade <0xfade@example.com>", "@0xFADE"));
        Assert.assertFalse((boolean)BouncyCastleGpgKeyLocatorTest.match("", "0x"));
    }
}

