/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal.keys;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.eclipse.jgit.gpg.bc.internal.keys.SecretKeys;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SecretKeysTest {
    private static volatile Boolean haveOCB;
    @Parameterized.Parameter
    public TestData data;

    @BeforeClass
    public static void ensureBC() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static boolean ocbAvailable() {
        Boolean haveIt = haveOCB;
        if (haveIt != null) {
            return haveIt;
        }
        try {
            Cipher c = Cipher.getInstance("AES/OCB/NoPadding");
            if (c == null) {
                haveOCB = Boolean.FALSE;
                return false;
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            haveOCB = Boolean.FALSE;
            return false;
        }
        haveOCB = Boolean.TRUE;
        return true;
    }

    @Parameterized.Parameters(name="{0}")
    public static TestData[] initTestData() {
        return new TestData[]{new TestData("AFDA8EA10E185ACF8C0D0F8885A0EF61A72ECB11", false, false), new TestData("2FB05DBB70FC07CB84C13431F640CA6CEA1DBF8A", false, true), new TestData("66CCECEC2AB46A9735B10FEC54EDF9FD0F77BAF9", true, true), new TestData("F727FAB884DA3BD402B6E0F5472E108D21033124", true, true), new TestData("faked", false, true)};
    }

    private static byte[] readTestKey(String filename) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream in = new BufferedInputStream(SecretKeysTest.class.getResourceAsStream(filename));){
            return SecretKeys.keyFromNameValueFormat((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static PGPPublicKey readAsc(InputStream in) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRings = pgpPub.getKeyRings();
        while (keyRings.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRings.next();
            Iterator keys = keyRing.getPublicKeys();
            if (!keys.hasNext()) continue;
            return (PGPPublicKey)keys.next();
        }
        return null;
    }

    @Test
    public void testKeyRead() throws Exception {
        block21: {
            if (this.data.keyValue) {
                byte[] bytes = SecretKeysTest.readTestKey(String.valueOf(this.data.name) + ".key");
                Assert.assertEquals((long)40L, (long)bytes[0]);
                Assert.assertEquals((long)41L, (long)bytes[bytes.length - 1]);
            }
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStream pubIn = this.getClass().getResourceAsStream(String.valueOf(this.data.name) + ".asc");){
                if (pubIn == null) break block21;
                PGPPublicKey publicKey = SecretKeysTest.readAsc(pubIn);
                PGPDigestCalculatorProvider calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder().build();
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(String.valueOf(this.data.name) + ".key"));){
                        PGPSecretKey secretKey = SecretKeys.readSecretKey((InputStream)in, (PGPDigestCalculatorProvider)calculatorProvider, (SecretKeys.PassphraseSupplier)(this.data.encrypted ? () -> "nonsense".toCharArray() : null), (PGPPublicKey)publicKey);
                        Assert.assertNotNull((Object)secretKey);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (PGPException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("OCB"));
                    Assert.assertTrue((boolean)this.data.encrypted);
                    Assert.assertFalse((boolean)SecretKeysTest.ocbAvailable());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private static class TestData {
        final String name;
        final boolean encrypted;
        final boolean keyValue;

        TestData(String name, boolean encrypted, boolean keyValue) {
            this.name = name;
            this.encrypted = encrypted;
            this.keyValue = keyValue;
        }

        public String toString() {
            return this.name;
        }
    }
}

