/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.resolver;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

public class DefaultReceivePackFactory
implements ReceivePackFactory<HttpServletRequest> {
    private static final Config.SectionParser<ServiceConfig> CONFIG = new Config.SectionParser<ServiceConfig>(){

        public ServiceConfig parse(Config cfg) {
            return new ServiceConfig(cfg);
        }
    };

    public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        ServiceConfig cfg = (ServiceConfig)db.getConfig().get(CONFIG);
        String user = req.getRemoteUser();
        if (cfg.set) {
            if (cfg.enabled) {
                if (user == null || "".equals(user)) {
                    user = "anonymous";
                }
                return DefaultReceivePackFactory.createFor(req, db, user);
            }
            throw new ServiceNotEnabledException();
        }
        if (user != null && !"".equals(user)) {
            return DefaultReceivePackFactory.createFor(req, db, user);
        }
        throw new ServiceNotAuthorizedException();
    }

    private static ReceivePack createFor(HttpServletRequest req, Repository db, String user) {
        ReceivePack rp = new ReceivePack(db);
        rp.setRefLogIdent(DefaultReceivePackFactory.toPersonIdent(req, user));
        return rp;
    }

    private static PersonIdent toPersonIdent(HttpServletRequest req, String user) {
        return new PersonIdent(user, user + "@" + req.getRemoteHost());
    }

    private static class ServiceConfig {
        final boolean set;
        final boolean enabled;

        ServiceConfig(Config cfg) {
            this.set = cfg.getString("http", null, "receivepack") != null;
            this.enabled = cfg.getBoolean("http", "receivepack", false);
        }
    }
}

