/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.resolver.AsIsFileService;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class AsIsFileFilter
implements Filter {
    private final AsIsFileService asIs;

    AsIsFileFilter(AsIsFileService getAnyFile) {
        this.asIs = getAnyFile;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            Repository db = ServletUtils.getRepository(request);
            this.asIs.access(req, db);
            chain.doFilter(request, response);
        }
        catch (ServiceNotAuthorizedException e) {
            res.sendError(401, e.getMessage());
        }
        catch (ServiceNotEnabledException e) {
            res.sendError(403, e.getMessage());
        }
    }
}

