/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServlet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.glue.ErrorServlet;
import org.eclipse.jgit.http.server.glue.ServletBinder;
import org.eclipse.jgit.http.server.glue.UrlPipeline;

abstract class ServletBinderImpl
implements ServletBinder {
    private final List<Filter> filters = new ArrayList<Filter>();
    private HttpServlet httpServlet;

    ServletBinderImpl() {
    }

    @Override
    public ServletBinder through(Filter filter) {
        if (filter == null) {
            throw new NullPointerException(HttpServerText.get().filterMustNotBeNull);
        }
        this.filters.add(filter);
        return this;
    }

    @Override
    public void with(HttpServlet servlet) {
        if (servlet == null) {
            throw new NullPointerException(HttpServerText.get().servletMustNotBeNull);
        }
        if (this.httpServlet != null) {
            throw new IllegalStateException(HttpServerText.get().servletWasAlreadyBound);
        }
        this.httpServlet = servlet;
    }

    protected HttpServlet getServlet() {
        if (this.httpServlet != null) {
            return this.httpServlet;
        }
        return new ErrorServlet(404);
    }

    protected Filter[] getFilters() {
        return this.filters.toArray(new Filter[0]);
    }

    abstract UrlPipeline create();
}

