/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.console;

import java.io.Console;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.ChainingCredentialsProvider;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.NetRCCredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ConsoleCredentialsProvider
extends CredentialsProvider {
    private final Console cons = System.console();

    public static void install() {
        ConsoleCredentialsProvider c = new ConsoleCredentialsProvider();
        if (c.cons == null) {
            throw new NoClassDefFoundError(CLIText.get().noSystemConsoleAvailable);
        }
        ChainingCredentialsProvider cp = new ChainingCredentialsProvider(new NetRCCredentialsProvider(), c);
        CredentialsProvider.setDefault(cp);
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem i = credentialItemArray[n2];
            if (!(i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        boolean ok = true;
        int i = 0;
        while (i < items.length && ok) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.StringType) {
                ok = this.get((CredentialItem.StringType)item);
            } else if (item instanceof CredentialItem.CharArrayType) {
                ok = this.get((CredentialItem.CharArrayType)item);
            } else if (item instanceof CredentialItem.YesNoType) {
                ok = this.get((CredentialItem.YesNoType)item);
            } else if (item instanceof CredentialItem.InformationalMessage) {
                ok = this.get((CredentialItem.InformationalMessage)item);
            } else {
                throw new UnsupportedCredentialItem(uri, item.getPromptText());
            }
            ++i;
        }
        return ok;
    }

    private boolean get(CredentialItem.StringType item) {
        if (item.isValueSecure()) {
            char[] v = this.cons.readPassword("%s: ", item.getPromptText());
            if (v != null) {
                item.setValue(new String(v));
                return true;
            }
            return false;
        }
        String v = this.cons.readLine("%s: ", item.getPromptText());
        if (v != null) {
            item.setValue(v);
            return true;
        }
        return false;
    }

    private boolean get(CredentialItem.CharArrayType item) {
        if (item.isValueSecure()) {
            char[] v = this.cons.readPassword("%s: ", item.getPromptText());
            if (v != null) {
                item.setValueNoCopy(v);
                return true;
            }
            return false;
        }
        String v = this.cons.readLine("%s: ", item.getPromptText());
        if (v != null) {
            item.setValueNoCopy(v.toCharArray());
            return true;
        }
        return false;
    }

    private boolean get(CredentialItem.InformationalMessage item) {
        this.cons.printf("%s\n", item.getPromptText());
        this.cons.flush();
        return true;
    }

    private boolean get(CredentialItem.YesNoType item) {
        String r = this.cons.readLine("%s [%s/%s]? ", item.getPromptText(), CLIText.get().answerYes, CLIText.get().answerNo);
        if (r != null) {
            item.setValue(CLIText.get().answerYes.equalsIgnoreCase(r));
            return true;
        }
        return false;
    }
}

