/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.StandardCopyOption;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefDirectoryRename
extends RefRename {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectoryRename.class);
    private final RefDirectory refdb;
    private ObjectId objId;
    private boolean updateHEAD;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RefUpdate.Result doRename() throws IOException {
        if (this.source.getRef().isSymbolic()) {
            return RefUpdate.Result.IO_FAILURE;
        }
        this.objId = this.source.getOldObjectId();
        this.updateHEAD = this.needToUpdateHEAD();
        this.tmp = this.refdb.newTemporaryUpdate();
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                RefUpdate.Result result;
                RevWalk rw = new RevWalk(this.refdb.getRepository());
                this.tmp.setNewObjectId(this.objId);
                this.tmp.setForceUpdate(true);
                this.tmp.disableRefLog();
                switch (this.tmp.update(rw)) {
                    case NO_CHANGE: 
                    case NEW: 
                    case FORCED: {
                        break;
                    }
                    default: {
                        result = this.tmp.getResult();
                        break block45;
                    }
                }
                if (!this.renameLog(this.source, this.tmp)) {
                    RefUpdate.Result result2 = RefUpdate.Result.IO_FAILURE;
                    try {
                        this.refdb.delete(this.tmp);
                        return result2;
                    }
                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                    return result2;
                }
                RefUpdate dst = this.destination;
                if (this.updateHEAD) {
                    if (!this.linkHEAD(this.destination)) {
                        this.renameLog(this.tmp, this.source);
                        RefUpdate.Result result3 = RefUpdate.Result.LOCK_FAILURE;
                        try {
                            this.refdb.delete(this.tmp);
                            return result3;
                        }
                        catch (IOException err) {
                            FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                        }
                        return result3;
                    }
                    dst = this.refdb.newUpdate("HEAD", false);
                    dst.setRefLogIdent(this.destination.getRefLogIdent());
                    dst.setRefLogMessage(this.destination.getRefLogMessage(), false);
                }
                this.source.setExpectedOldObjectId(this.objId);
                this.source.setForceUpdate(true);
                this.source.disableRefLog();
                if (this.source.delete(rw) != RefUpdate.Result.FORCED) {
                    this.renameLog(this.tmp, this.source);
                    if (this.updateHEAD) {
                        this.linkHEAD(this.source);
                    }
                    RefUpdate.Result result4 = this.source.getResult();
                    try {
                        this.refdb.delete(this.tmp);
                        return result4;
                    }
                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                    return result4;
                }
                if (!this.renameLog(this.tmp, this.destination)) {
                    this.renameLog(this.tmp, this.source);
                    this.source.setExpectedOldObjectId(ObjectId.zeroId());
                    this.source.setNewObjectId(this.objId);
                    this.source.update(rw);
                    if (this.updateHEAD) {
                        this.linkHEAD(this.source);
                    }
                    RefUpdate.Result result5 = RefUpdate.Result.IO_FAILURE;
                    try {
                        this.refdb.delete(this.tmp);
                        return result5;
                    }
                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                    return result5;
                }
                dst.setExpectedOldObjectId(ObjectId.zeroId());
                dst.setNewObjectId(this.objId);
                if (dst.update(rw) != RefUpdate.Result.NEW) {
                    if (this.renameLog(this.destination, this.tmp)) {
                        this.renameLog(this.tmp, this.source);
                    }
                    this.source.setExpectedOldObjectId(ObjectId.zeroId());
                    this.source.setNewObjectId(this.objId);
                    this.source.update(rw);
                    if (this.updateHEAD) {
                        this.linkHEAD(this.source);
                    }
                    RefUpdate.Result result6 = dst.getResult();
                    try {
                        this.refdb.delete(this.tmp);
                        return result6;
                    }
                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                    return result6;
                }
                RefUpdate.Result result7 = RefUpdate.Result.RENAMED;
                try {
                    this.refdb.delete(this.tmp);
                    return result7;
                }
                catch (IOException err) {
                    FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                }
                return result7;
                {
                    block45: {
                        finally {
                            if (rw == null) break block45;
                            rw.close();
                        }
                    }
                    try {
                        this.refdb.delete(this.tmp);
                        return result;
                    }
                    catch (IOException err) {
                        FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
                    }
                    return result;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            try {
                this.refdb.delete(this.tmp);
                throw throwable;
            }
            catch (IOException err) {
                FileUtils.delete(this.refdb.fileFor(this.tmp.getName()));
            }
            throw throwable;
        }
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.logFor(src.getName());
        File dstLog = this.refdb.logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException e) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (IOException e) {
            // empty catch block
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), e);
            return false;
        }
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NO_CHANGE: 
                case NEW: 
                case FORCED: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

