/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.lfs.CleanFilter;
import org.eclipse.jgit.lfs.InstallBuiltinLfsCommand;
import org.eclipse.jgit.lfs.LfsBlobFilter;
import org.eclipse.jgit.lfs.LfsPrePushHook;
import org.eclipse.jgit.lfs.SmudgeFilter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.LfsFactory;

public class BuiltinLFS
extends LfsFactory {
    private BuiltinLFS() {
        SmudgeFilter.register();
        CleanFilter.register();
    }

    public static void register() {
        BuiltinLFS.setInstance(new BuiltinLFS());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public ObjectLoader applySmudgeFilter(Repository db, ObjectLoader loader, Attribute attribute) throws IOException {
        if (this.isEnabled(db) && (attribute == null || this.isEnabled(db, attribute))) {
            return LfsBlobFilter.smudgeLfsBlob(db, loader);
        }
        return loader;
    }

    @Override
    public LfsFactory.LfsInputStream applyCleanFilter(Repository db, InputStream input, long length, Attribute attribute) throws IOException {
        if (this.isEnabled(db, attribute)) {
            return new LfsFactory.LfsInputStream(LfsBlobFilter.cleanLfsBlob(db, input));
        }
        return new LfsFactory.LfsInputStream(input, length);
    }

    @Override
    @Nullable
    public PrePushHook getPrePushHook(Repository repo, PrintStream outputStream) {
        if (this.isEnabled(repo)) {
            return new LfsPrePushHook(repo, outputStream);
        }
        return null;
    }

    @Override
    public boolean isEnabled(Repository db) {
        if (db == null) {
            return false;
        }
        return db.getConfig().getBoolean("filter", "lfs", "useJGitBuiltin", false);
    }

    private boolean isEnabled(Repository db, Attribute attribute) {
        if (attribute == null) {
            return false;
        }
        return this.isEnabled(db) && "lfs".equals(attribute.getValue());
    }

    @Override
    public LfsFactory.LfsInstallCommand getInstallCommand() {
        return new InstallBuiltinLfsCommand();
    }
}

