/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.util.IO;

public class LfsBlobLoader
extends ObjectLoader {
    private Path mediaFile;
    private BasicFileAttributes attributes;
    private byte[] cached;

    public LfsBlobLoader(Path mediaFile) throws IOException {
        this.mediaFile = mediaFile;
        this.attributes = Files.readAttributes(mediaFile, BasicFileAttributes.class, new LinkOption[0]);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public long getSize() {
        return this.attributes.size();
    }

    @Override
    public byte[] getCachedBytes() throws LargeObjectException {
        if (this.getSize() > 0x3200000L) {
            throw new LargeObjectException();
        }
        if (this.cached == null) {
            try {
                this.cached = IO.readFully(this.mediaFile.toFile());
            }
            catch (IOException ioe) {
                throw new LargeObjectException(ioe);
            }
        }
        return this.cached;
    }

    @Override
    public ObjectStream openStream() throws MissingObjectException, IOException {
        return new ObjectStream.Filter(this.getType(), this.getSize(), Files.newInputStream(this.mediaFile, new OpenOption[0]));
    }
}

