/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class LongObjectId
extends AnyLongObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final LongObjectId ZEROID = new LongObjectId(0L, 0L, 0L, 0L);
    private static final String ZEROID_STR = ZEROID.name();

    public static final LongObjectId zeroId() {
        return ZEROID;
    }

    public static final boolean isId(String id) {
        if (id.length() != 64) {
            return false;
        }
        try {
            int i = 0;
            while (i < 64) {
                RawParseUtils.parseHexInt4((byte)id.charAt(i));
                ++i;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static final String toString(LongObjectId i) {
        return i != null ? i.name() : ZEROID_STR;
    }

    public static boolean equals(byte[] firstBuffer, int fi, byte[] secondBuffer, int si) {
        return firstBuffer[fi] == secondBuffer[si] && firstBuffer[fi + 1] == secondBuffer[si + 1] && firstBuffer[fi + 2] == secondBuffer[si + 2] && firstBuffer[fi + 3] == secondBuffer[si + 3] && firstBuffer[fi + 4] == secondBuffer[si + 4] && firstBuffer[fi + 5] == secondBuffer[si + 5] && firstBuffer[fi + 6] == secondBuffer[si + 6] && firstBuffer[fi + 7] == secondBuffer[si + 7] && firstBuffer[fi + 8] == secondBuffer[si + 8] && firstBuffer[fi + 9] == secondBuffer[si + 9] && firstBuffer[fi + 10] == secondBuffer[si + 10] && firstBuffer[fi + 11] == secondBuffer[si + 11] && firstBuffer[fi + 12] == secondBuffer[si + 12] && firstBuffer[fi + 13] == secondBuffer[si + 13] && firstBuffer[fi + 14] == secondBuffer[si + 14] && firstBuffer[fi + 15] == secondBuffer[si + 15] && firstBuffer[fi + 16] == secondBuffer[si + 16] && firstBuffer[fi + 17] == secondBuffer[si + 17] && firstBuffer[fi + 18] == secondBuffer[si + 18] && firstBuffer[fi + 19] == secondBuffer[si + 19] && firstBuffer[fi + 20] == secondBuffer[si + 20] && firstBuffer[fi + 21] == secondBuffer[si + 21] && firstBuffer[fi + 22] == secondBuffer[si + 22] && firstBuffer[fi + 23] == secondBuffer[si + 23] && firstBuffer[fi + 24] == secondBuffer[si + 24] && firstBuffer[fi + 25] == secondBuffer[si + 25] && firstBuffer[fi + 26] == secondBuffer[si + 26] && firstBuffer[fi + 27] == secondBuffer[si + 27] && firstBuffer[fi + 28] == secondBuffer[si + 28] && firstBuffer[fi + 29] == secondBuffer[si + 29] && firstBuffer[fi + 30] == secondBuffer[si + 30] && firstBuffer[fi + 31] == secondBuffer[si + 31];
    }

    public static final LongObjectId fromRaw(byte[] bs) {
        return LongObjectId.fromRaw(bs, 0);
    }

    public static final LongObjectId fromRaw(byte[] bs, int p) {
        long a = NB.decodeInt64(bs, p);
        long b = NB.decodeInt64(bs, p + 8);
        long c = NB.decodeInt64(bs, p + 16);
        long d = NB.decodeInt64(bs, p + 24);
        return new LongObjectId(a, b, c, d);
    }

    public static final LongObjectId fromRaw(long[] is) {
        return LongObjectId.fromRaw(is, 0);
    }

    public static final LongObjectId fromRaw(long[] is, int p) {
        return new LongObjectId(is[p], is[p + 1], is[p + 2], is[p + 3]);
    }

    public static final LongObjectId fromString(byte[] buf, int offset) {
        return LongObjectId.fromHexString(buf, offset);
    }

    public static LongObjectId fromString(String str) {
        if (str.length() != 64) {
            throw new InvalidLongObjectIdException(str);
        }
        return LongObjectId.fromHexString(Constants.encodeASCII(str), 0);
    }

    private static final LongObjectId fromHexString(byte[] bs, int p) {
        try {
            long a = RawParseUtils.parseHexInt64(bs, p);
            long b = RawParseUtils.parseHexInt64(bs, p + 16);
            long c = RawParseUtils.parseHexInt64(bs, p + 32);
            long d = RawParseUtils.parseHexInt64(bs, p + 48);
            return new LongObjectId(a, b, c, d);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidLongObjectIdException(bs, p, 64);
        }
    }

    LongObjectId(long new_1, long new_2, long new_3, long new_4) {
        this.w1 = new_1;
        this.w2 = new_2;
        this.w3 = new_3;
        this.w4 = new_4;
    }

    protected LongObjectId(AnyLongObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
    }

    @Override
    public LongObjectId toObjectId() {
        return this;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeLong(this.w1);
        os.writeLong(this.w2);
        os.writeLong(this.w3);
        os.writeLong(this.w4);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        this.w1 = ois.readLong();
        this.w2 = ois.readLong();
        this.w3 = ois.readLong();
        this.w4 = ois.readLong();
    }
}

