/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.ObjectDownloadListener;
import org.eclipse.jgit.lfs.server.fs.ObjectUploadListener;
import org.eclipse.jgit.lfs.server.internal.LfsGson;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;

@WebServlet(asyncSupported=true)
public class FileLfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final FileLfsRepository repository;
    private final long timeout;

    public FileLfsServlet(FileLfsRepository repository, long timeout) {
        this.repository = repository;
        this.timeout = timeout;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId obj = this.getObjectToTransfer(req, rsp);
        if (obj != null) {
            if (this.repository.getSize(obj) == -1L) {
                FileLfsServlet.sendError(rsp, 404, MessageFormat.format(LfsServerText.get().objectNotFound, obj.getName()));
                return;
            }
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            rsp.getOutputStream().setWriteListener(new ObjectDownloadListener(this.repository, context, rsp, obj));
        }
    }

    protected AnyLongObjectId getObjectToTransfer(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String info = req.getPathInfo();
        int length = 65;
        if (info.length() != length) {
            FileLfsServlet.sendError(rsp, 422, MessageFormat.format(LfsServerText.get().invalidPathInfo, info));
            return null;
        }
        try {
            return LongObjectId.fromString(info.substring(1, length));
        }
        catch (InvalidLongObjectIdException e) {
            FileLfsServlet.sendError(rsp, 422, e.getMessage());
            return null;
        }
    }

    @Override
    protected void doPut(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId id = this.getObjectToTransfer(req, rsp);
        if (id != null) {
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            req.getInputStream().setReadListener(new ObjectUploadListener(this.repository, context, req, rsp, id));
        }
    }

    protected static void sendError(HttpServletResponse rsp, int status, String message) throws IOException {
        if (rsp.isCommitted()) {
            rsp.getOutputStream().close();
            return;
        }
        rsp.reset();
        rsp.setStatus(status);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PrintWriter writer = rsp.getWriter();){
            LfsGson.toJson(message, writer);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        rsp.flushBuffer();
    }
}

