/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.s3;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.Response;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;
import org.eclipse.jgit.lfs.server.s3.S3Config;
import org.eclipse.jgit.lfs.server.s3.SignerV4;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.HttpClientConnectionFactory;
import org.eclipse.jgit.util.HttpSupport;

public class S3Repository
implements LargeFileRepository {
    private S3Config s3Config;

    public S3Repository(S3Config config) {
        this.validateConfig(config);
        this.s3Config = config;
    }

    @Override
    public Response.Action getDownloadAction(AnyLongObjectId oid) {
        URL endpointUrl = this.getObjectUrl(oid);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("X-Amz-Expires", Integer.toString(this.s3Config.getExpirationSeconds()));
        HashMap<String, String> headers = new HashMap<String, String>();
        String authorizationQueryParameters = SignerV4.createAuthorizationQuery(this.s3Config, endpointUrl, "GET", headers, queryParams, "UNSIGNED-PAYLOAD");
        Response.Action a = new Response.Action();
        a.href = String.valueOf(endpointUrl.toString()) + "?" + authorizationQueryParameters;
        return a;
    }

    @Override
    public Response.Action getUploadAction(AnyLongObjectId oid, long size) {
        this.cacheObjectMetaData(oid, size);
        URL objectUrl = this.getObjectUrl(oid);
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("x-amz-content-sha256", oid.getName());
        headers.put("Content-Length", Long.toString(size));
        headers.put("x-amz-storage-class", this.s3Config.getStorageClass());
        headers.put("Content-Type", "application/octet-stream");
        headers = SignerV4.createHeaderAuthorization(this.s3Config, objectUrl, "PUT", headers, oid.getName());
        Response.Action a = new Response.Action();
        a.href = objectUrl.toString();
        a.header = new HashMap<String, String>();
        a.header.putAll(headers);
        return a;
    }

    @Override
    public Response.Action getVerifyAction(AnyLongObjectId id) {
        return null;
    }

    @Override
    public long getSize(AnyLongObjectId oid) throws IOException {
        String contentLengthHeader;
        URL endpointUrl = this.getObjectUrl(oid);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("X-Amz-Expires", Integer.toString(this.s3Config.getExpirationSeconds()));
        HashMap<String, String> headers = new HashMap<String, String>();
        String authorizationQueryParameters = SignerV4.createAuthorizationQuery(this.s3Config, endpointUrl, "HEAD", headers, queryParams, "UNSIGNED-PAYLOAD");
        String href = String.valueOf(endpointUrl.toString()) + "?" + authorizationQueryParameters;
        Proxy proxy = HttpSupport.proxyFor(ProxySelector.getDefault(), endpointUrl);
        HttpClientConnectionFactory f = new HttpClientConnectionFactory();
        HttpConnection conn = f.create(new URL(href), proxy);
        if (this.s3Config.isDisableSslVerify()) {
            HttpSupport.disableSslVerify(conn);
        }
        conn.setRequestMethod("HEAD");
        conn.connect();
        int status = conn.getResponseCode();
        if (status == 200 && (contentLengthHeader = conn.getHeaderField("Content-Length")) != null) {
            return Integer.parseInt(contentLengthHeader);
        }
        return -1L;
    }

    protected void cacheObjectMetaData(AnyLongObjectId oid, long size) {
    }

    private void validateConfig(S3Config config) {
        this.assertNotEmpty(LfsServerText.get().undefinedS3AccessKey, config.getAccessKey());
        this.assertNotEmpty(LfsServerText.get().undefinedS3Bucket, config.getBucket());
        this.assertNotEmpty(LfsServerText.get().undefinedS3Region, config.getRegion());
        this.assertNotEmpty(LfsServerText.get().undefinedS3SecretKey, config.getSecretKey());
        this.assertNotEmpty(LfsServerText.get().undefinedS3StorageClass, config.getStorageClass());
    }

    private void assertNotEmpty(String message, String value) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private URL getObjectUrl(AnyLongObjectId oid) {
        try {
            return new URL(String.format("https://s3-%s.amazonaws.com/%s/%s", this.s3Config.getRegion(), this.s3Config.getBucket(), this.getPath(oid)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(MessageFormat.format(LfsServerText.get().unparsableEndpoint, e.getMessage()));
        }
    }

    private String getPath(AnyLongObjectId oid) {
        return oid.getName();
    }
}

