/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(usage="usage_ShowDiffTree")
class DiffTree
extends TextBuiltin {
    @Option(name="--recursive", usage="usage_recurseIntoSubtrees", aliases={"-r"})
    private boolean recursive;
    @Argument(index=1, metaVar="metaVar_treeish", required=true)
    private List<AbstractTreeIterator> trees = new ArrayList<AbstractTreeIterator>();
    @Option(name="--", metaVar="metaVar_path", handler=PathTreeFilterHandler.class)
    private TreeFilter pathFilter = TreeFilter.ALL;

    DiffTree() {
    }

    @Argument(index=0, metaVar="metaVar_treeish", required=true)
    void tree_0(AbstractTreeIterator c) {
        this.trees.add(c);
    }

    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TreeWalk walk = new TreeWalk(this.db);){
            walk.setRecursive(this.recursive);
            for (AbstractTreeIterator i : this.trees) {
                walk.addTree(i);
            }
            walk.setFilter(AndTreeFilter.create(TreeFilter.ANY_DIFF, this.pathFilter));
            int nTree = walk.getTreeCount();
            while (walk.next()) {
                int i = 1;
                while (i < nTree) {
                    this.outw.print(':');
                    ++i;
                }
                i = 0;
                while (i < nTree) {
                    FileMode m = walk.getFileMode(i);
                    String s = m.toString();
                    int pad = 6 - s.length();
                    while (pad > 0) {
                        this.outw.print('0');
                        --pad;
                    }
                    this.outw.print(s);
                    this.outw.print(' ');
                    ++i;
                }
                i = 0;
                while (i < nTree) {
                    this.outw.print(walk.getObjectId(i).name());
                    this.outw.print(' ');
                    ++i;
                }
                int chg = 77;
                if (nTree == 2) {
                    int m0 = walk.getRawMode(0);
                    int m1 = walk.getRawMode(1);
                    if (m0 == 0 && m1 != 0) {
                        chg = 65;
                    } else if (m0 != 0 && m1 == 0) {
                        chg = 68;
                    } else if (m0 != m1 && walk.idEqual(0, 1)) {
                        chg = 84;
                    }
                }
                this.outw.print((char)chg);
                this.outw.print('\t');
                this.outw.print(walk.getPathString());
                this.outw.println();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

