/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.AuthorRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitterRevFilter;
import org.eclipse.jgit.revwalk.filter.MessageRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

abstract class RevWalkTextBuiltin
extends TextBuiltin {
    RevWalk walk;
    @Option(name="--objects")
    boolean objects = false;
    @Option(name="--parents")
    boolean parents = false;
    @Option(name="--total-count")
    boolean count = false;
    @Option(name="--all")
    boolean all = false;
    char[] outbuffer = new char[40];
    private final EnumSet<RevSort> sorting = EnumSet.noneOf(RevSort.class);
    @Option(name="--follow", metaVar="metaVar_path")
    private String followPath;
    @Argument(index=0, metaVar="metaVar_commitish")
    private List<RevCommit> commits = new ArrayList<RevCommit>();
    @Option(name="--", metaVar="metaVar_path", handler=PathTreeFilterHandler.class)
    protected TreeFilter pathFilter = TreeFilter.ALL;
    private final List<RevFilter> revLimiter = new ArrayList<RevFilter>();
    @Option(name="--max-count", aliases={"-n"}, metaVar="metaVar_n")
    private int maxCount = -1;

    RevWalkTextBuiltin() {
    }

    private void enableRevSort(RevSort type, boolean on) {
        if (on) {
            this.sorting.add(type);
        } else {
            this.sorting.remove((Object)type);
        }
    }

    @Option(name="--date-order")
    void enableDateOrder(boolean on) {
        this.enableRevSort(RevSort.COMMIT_TIME_DESC, on);
    }

    @Option(name="--topo-order")
    void enableTopoOrder(boolean on) {
        this.enableRevSort(RevSort.TOPO, on);
    }

    @Option(name="--reverse")
    void enableReverse(boolean on) {
        this.enableRevSort(RevSort.REVERSE, on);
    }

    @Option(name="--boundary")
    void enableBoundary(boolean on) {
        this.enableRevSort(RevSort.BOUNDARY, on);
    }

    @Option(name="--author")
    void addAuthorRevFilter(String who) {
        this.revLimiter.add(AuthorRevFilter.create(who));
    }

    @Option(name="--committer")
    void addCommitterRevFilter(String who) {
        this.revLimiter.add(CommitterRevFilter.create(who));
    }

    @Option(name="--grep")
    void addCMessageRevFilter(String msg) {
        this.revLimiter.add(MessageRevFilter.create(msg));
    }

    @Override
    protected void run() throws Exception {
        this.walk = this.createWalk();
        for (RevSort s : this.sorting) {
            this.walk.sort(s, true);
        }
        if (this.pathFilter == TreeFilter.ALL) {
            if (this.followPath != null) {
                this.walk.setTreeFilter(FollowFilter.create(this.followPath, this.db.getConfig().get(DiffConfig.KEY)));
            }
        } else if (this.pathFilter != TreeFilter.ALL) {
            this.walk.setTreeFilter(AndTreeFilter.create(this.pathFilter, TreeFilter.ANY_DIFF));
        }
        if (this.revLimiter.size() == 1) {
            this.walk.setRevFilter(this.revLimiter.get(0));
        } else if (this.revLimiter.size() > 1) {
            this.walk.setRevFilter(AndRevFilter.create(this.revLimiter));
        }
        if (this.all) {
            for (Ref a : this.db.getRefDatabase().getRefs()) {
                ObjectId oid = a.getPeeledObjectId();
                if (oid == null) {
                    oid = a.getObjectId();
                }
                try {
                    this.commits.add(this.walk.parseCommit(oid));
                }
                catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                    // empty catch block
                }
            }
        }
        if (this.commits.isEmpty()) {
            ObjectId head = this.db.resolve("HEAD");
            if (head == null) {
                throw RevWalkTextBuiltin.die(MessageFormat.format(CLIText.get().cannotResolve, "HEAD"));
            }
            this.commits.add(this.walk.parseCommit(head));
        }
        for (RevCommit c : this.commits) {
            RevCommit real;
            RevCommit revCommit = real = this.argWalk == this.walk ? c : this.walk.parseCommit(c);
            if (c.has(RevFlag.UNINTERESTING)) {
                this.walk.markUninteresting(real);
                continue;
            }
            this.walk.markStart(real);
        }
        long start = System.currentTimeMillis();
        int n = this.walkLoop();
        if (this.count) {
            long end = System.currentTimeMillis();
            this.errw.print(n);
            this.errw.print(' ');
            this.errw.println(MessageFormat.format(CLIText.get().timeInMilliSeconds, end - start));
        }
    }

    protected RevWalk createWalk() {
        RevWalk result = this.objects ? new ObjectWalk(this.db) : (this.argWalk != null ? this.argWalk : (this.argWalk = new RevWalk(this.db)));
        result.setRewriteParents(false);
        return result;
    }

    protected int walkLoop() throws Exception {
        int n = 0;
        for (RevCommit c : this.walk) {
            if (++n > this.maxCount && this.maxCount >= 0) break;
            this.show(c);
        }
        if (this.walk instanceof ObjectWalk) {
            RevObject obj;
            ObjectWalk ow = (ObjectWalk)this.walk;
            while ((obj = ow.nextObject()) != null) {
                this.show(ow, obj);
            }
        }
        return n;
    }

    protected abstract void show(RevCommit var1) throws Exception;

    protected void show(ObjectWalk objectWalk, RevObject currentObject) throws Exception {
    }
}

