/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;

@Command(usage="usage_ShowRef")
class ShowRef
extends TextBuiltin {
    ShowRef() {
    }

    @Override
    protected void run() throws Exception {
        for (Ref r : this.getSortedRefs()) {
            this.show(r.getObjectId(), r.getName());
            if (r.getPeeledObjectId() == null) continue;
            this.show(r.getPeeledObjectId(), String.valueOf(r.getName()) + "^{}");
        }
    }

    private Iterable<Ref> getSortedRefs() throws Exception {
        List<Ref> all = this.db.getRefDatabase().getRefs();
        return RefComparator.sort(all);
    }

    private void show(AnyObjectId id, String name) throws IOException {
        this.outw.print(id.name());
        this.outw.print('\t');
        this.outw.print(name);
        this.outw.println();
    }
}

