/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Option;

@Command(usage="usage_DiffAlgorithms")
class DiffAlgorithms
extends TextBuiltin {
    final Algorithm myers = new Algorithm(){

        @Override
        DiffAlgorithm create() {
            return MyersDiff.INSTANCE;
        }
    };
    final Algorithm histogram = new Algorithm(){

        @Override
        DiffAlgorithm create() {
            HistogramDiff d = new HistogramDiff();
            d.setFallbackAlgorithm(null);
            return d;
        }
    };
    final Algorithm histogram_myers = new Algorithm(){

        @Override
        DiffAlgorithm create() {
            HistogramDiff d = new HistogramDiff();
            d.setFallbackAlgorithm(MyersDiff.INSTANCE);
            return d;
        }
    };
    @Option(name="--algorithm", metaVar="NAME", usage="Enable algorithm(s)")
    List<String> algorithms = new ArrayList<String>();
    @Option(name="--text-limit", metaVar="LIMIT", usage="Maximum size in KiB to scan per file revision")
    int textLimit = 15360;
    @Option(name="--repository", aliases={"-r"}, metaVar="GIT_DIR", usage="Repository to scan")
    List<File> gitDirs = new ArrayList<File>();
    @Option(name="--count", metaVar="LIMIT", usage="Number of file revisions to be compared")
    int count = 0;
    private final RawTextComparator cmp = RawTextComparator.DEFAULT;
    private ThreadMXBean mxBean;
    private static final int minCPUTimerTicks = 10;

    DiffAlgorithms() {
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() throws Exception {
        this.mxBean = ManagementFactory.getThreadMXBean();
        if (!this.mxBean.isCurrentThreadCpuTimeSupported()) {
            throw DiffAlgorithms.die("Current thread CPU time not supported on this JRE");
        }
        if (this.gitDirs.isEmpty()) {
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(this.gitdir))).readEnvironment()).findGitDir();
            if (rb.getGitDir() == null) {
                throw DiffAlgorithms.die(CLIText.get().cantFindGitDirectory);
            }
            this.gitDirs.add(rb.getGitDir());
        }
        for (File dir : this.gitDirs) {
            RepositoryBuilder rb = new RepositoryBuilder();
            if (RepositoryCache.FileKey.isGitRepository(dir, FS.DETECTED)) {
                rb.setGitDir(dir);
            } else {
                rb.findGitDir(dir);
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (Object repo = rb.build();){
                this.run((Repository)repo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void run(Repository repo) throws Exception {
        AbbreviatedObjectId startId;
        List<Test> all = this.init();
        long files = 0L;
        int commits = 0;
        int minN = Integer.MAX_VALUE;
        int maxN = 0;
        Throwable throwable = null;
        Object var10_9 = null;
        try {
            ObjectReader or = repo.newObjectReader();
            try {
                try (RevWalk rw = new RevWalk(or);){
                    RevCommit c;
                    MutableObjectId id = new MutableObjectId();
                    TreeWalk tw = new TreeWalk(or);
                    tw.setFilter(TreeFilter.ANY_DIFF);
                    tw.setRecursive(true);
                    ObjectId start = repo.resolve("HEAD");
                    startId = or.abbreviate(start);
                    rw.markStart(rw.parseCommit(start));
                    while ((c = rw.next()) != null) {
                        ++commits;
                        if (c.getParentCount() != 1) continue;
                        RevCommit p = c.getParent(0);
                        rw.parseHeaders(p);
                        tw.reset(p.getTree(), c.getTree());
                        while (tw.next()) {
                            byte[] raw1;
                            byte[] raw0;
                            if (!DiffAlgorithms.isFile(tw, 0) || !DiffAlgorithms.isFile(tw, 1)) continue;
                            try {
                                tw.getObjectId(id, 0);
                                raw0 = or.open(id).getCachedBytes(this.textLimit * 1024);
                            }
                            catch (LargeObjectException tooBig) {
                                continue;
                            }
                            if (RawText.isBinary(raw0)) continue;
                            try {
                                tw.getObjectId(id, 1);
                                raw1 = or.open(id).getCachedBytes(this.textLimit * 1024);
                            }
                            catch (LargeObjectException tooBig) {
                                continue;
                            }
                            if (RawText.isBinary(raw1)) continue;
                            RawText txt0 = new RawText(raw0);
                            RawText txt1 = new RawText(raw1);
                            minN = Math.min(minN, txt0.size() + txt1.size());
                            maxN = Math.max(maxN, txt0.size() + txt1.size());
                            for (Test test : all) {
                                this.testOne(test, txt0, txt1);
                            }
                            ++files;
                        }
                        if (this.count > 0 && files > (long)this.count) break;
                    }
                }
                if (or != null) {
                    or.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (or != null) {
                    or.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Collections.sort(all, new Comparator<Test>(){

            @Override
            public int compare(Test a, Test b) {
                int result = Long.signum(a.runningTimeNanos - b.runningTimeNanos);
                if (result == 0) {
                    result = a.algorithm.name.compareTo(b.algorithm.name);
                }
                return result;
            }
        });
        File directory = repo.getDirectory();
        if (directory != null) {
            String name = directory.getName();
            File parent = directory.getParentFile();
            if (name.equals(".git") && parent != null) {
                name = parent.getName();
            }
            this.outw.println(String.valueOf(name) + ": start at " + startId.name());
        }
        this.outw.format("  %12d files,     %8d commits\n", files, commits);
        this.outw.format("  N=%10d min lines, %8d max lines\n", minN, maxN);
        this.outw.format("%-25s %12s ( %12s  %12s )\n", "Algorithm", "Time(ns)", "Time(ns) on", "Time(ns) on");
        this.outw.format("%-25s %12s ( %12s  %12s )\n", "", "", "N=" + minN, "N=" + maxN);
        this.outw.println("---------------------------------------------------------------------");
        for (Test test : all) {
            this.outw.format("%-25s %12d ( %12d  %12d )", test.algorithm.name, test.runningTimeNanos, test.minN.runningTimeNanos, test.maxN.runningTimeNanos);
            this.outw.println();
        }
        this.outw.println();
        this.outw.flush();
    }

    private static boolean isFile(TreeWalk tw, int ithTree) {
        FileMode fm = tw.getFileMode(ithTree);
        return FileMode.REGULAR_FILE.equals(fm) || FileMode.EXECUTABLE_FILE.equals(fm);
    }

    private void testOne(Test test, RawText a, RawText b) {
        long startTime;
        DiffAlgorithm da = test.algorithm.create();
        int cpuTimeChanges = 0;
        int cnt = 0;
        long lastTime = startTime = this.mxBean.getCurrentThreadCpuTime();
        while (cpuTimeChanges < 10) {
            da.diff(this.cmp, a, b);
            ++cnt;
            long interimTime = this.mxBean.getCurrentThreadCpuTime();
            if (interimTime == lastTime) continue;
            ++cpuTimeChanges;
            lastTime = interimTime;
        }
        long stopTime = this.mxBean.getCurrentThreadCpuTime();
        long runTime = (stopTime - startTime) / (long)cnt;
        test.runningTimeNanos += runTime;
        if (test.minN == null || a.size() + b.size() < test.minN.n) {
            test.minN = new Run();
            test.minN.n = a.size() + b.size();
            test.minN.runningTimeNanos = runTime;
        }
        if (test.maxN == null || a.size() + b.size() > test.maxN.n) {
            test.maxN = new Run();
            test.maxN.n = a.size() + b.size();
            test.maxN.runningTimeNanos = runTime;
        }
    }

    private List<Test> init() {
        ArrayList<Test> all = new ArrayList<Test>();
        try {
            Field[] fieldArray = DiffAlgorithms.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.getType() == Algorithm.class) {
                    f.setAccessible(true);
                    Algorithm alg = (Algorithm)f.get(this);
                    alg.name = f.getName();
                    if (DiffAlgorithms.included(alg.name, this.algorithms)) {
                        Test test = new Test();
                        test.algorithm = alg;
                        all.add(test);
                    }
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            throw DiffAlgorithms.die("Cannot determine names", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw DiffAlgorithms.die("Cannot determine names", (Throwable)e);
        }
        return all;
    }

    private static boolean included(String name, List<String> want) {
        if (want.isEmpty()) {
            return true;
        }
        for (String s : want) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static abstract class Algorithm {
        String name;

        private Algorithm() {
        }

        abstract DiffAlgorithm create();
    }

    private static class Run {
        int n;
        long runningTimeNanos;

        private Run() {
        }
    }

    private static class Test {
        Algorithm algorithm;
        long runningTimeNanos;
        Run minN;
        Run maxN;

        private Test() {
        }
    }
}

