/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.internal.storage.reftree.RefTreeDatabase;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

@Command(usage="usage_RebuildRefTree")
class RebuildRefTree
extends TextBuiltin {
    @Option(name="--enable", usage="usage_RebuildRefTreeEnable")
    boolean enable;
    private String txnNamespace;
    private String txnCommitted;

    RebuildRefTree() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            ObjectReader reader = this.db.newObjectReader();
            try {
                RevWalk rw = new RevWalk(reader);
                try {
                    block32: {
                        block31: {
                            ObjectId oldTreeId;
                            RefTreeDatabase d;
                            ObjectInserter inserter = this.db.newObjectInserter();
                            RefDatabase refDb = this.db.getRefDatabase();
                            if (refDb instanceof RefTreeDatabase) {
                                d = (RefTreeDatabase)refDb;
                                refDb = d.getBootstrap();
                                this.txnNamespace = d.getTxnNamespace();
                                this.txnCommitted = d.getTxnCommitted();
                            } else {
                                d = new RefTreeDatabase(this.db, refDb);
                                this.txnNamespace = d.getTxnNamespace();
                                this.txnCommitted = d.getTxnCommitted();
                            }
                            this.errw.format("Rebuilding %s from %s", this.txnCommitted, refDb.getClass().getSimpleName());
                            this.errw.println();
                            this.errw.flush();
                            CommitBuilder b = new CommitBuilder();
                            Ref ref = refDb.exactRef(this.txnCommitted);
                            RefUpdate update = refDb.newUpdate(this.txnCommitted, true);
                            if (ref != null && ref.getObjectId() != null) {
                                ObjectId oldId = ref.getObjectId();
                                update.setExpectedOldObjectId(oldId);
                                b.setParentId(oldId);
                                oldTreeId = rw.parseCommit(oldId).getTree();
                            } else {
                                update.setExpectedOldObjectId(ObjectId.zeroId());
                                oldTreeId = ObjectId.zeroId();
                            }
                            RefTree tree = this.rebuild(refDb);
                            b.setTreeId(tree.writeTree(inserter));
                            b.setAuthor(new PersonIdent(this.db));
                            b.setCommitter(b.getAuthor());
                            if (b.getTreeId().equals(oldTreeId)) {
                            }
                            update.setNewObjectId(inserter.insert(b));
                            inserter.flush();
                            RefUpdate.Result result = update.update(rw);
                            switch (result) {
                                case NEW: 
                                case FAST_FORWARD: {
                                    break;
                                }
                                default: {
                                    throw RebuildRefTree.die(String.format("%s: %s", new Object[]{update.getName(), result}));
                                }
                            }
                            if (this.enable && !(this.db.getRefDatabase() instanceof RefTreeDatabase)) {
                                StoredConfig cfg = this.db.getConfig();
                                cfg.setInt("core", null, "repositoryformatversion", 1);
                                cfg.setString("extensions", null, "refStorage", "reftree");
                                cfg.save();
                                this.errw.println("Enabled reftree.");
                                this.errw.flush();
                            }
                            break block32;
                            finally {
                                if (inserter == null) break block31;
                                inserter.close();
                            }
                        }
                        if (rw != null) {
                            rw.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        return;
                    }
                    if (rw != null) {
                        rw.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (rw == null) throw throwable;
                    rw.close();
                    throw throwable;
                }
                if (reader == null) return;
                reader.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private RefTree rebuild(RefDatabase refdb) throws IOException {
        RefTree tree = RefTree.newEmptyTree();
        ArrayList<org.eclipse.jgit.internal.storage.reftree.Command> cmds = new ArrayList<org.eclipse.jgit.internal.storage.reftree.Command>();
        Ref head = refdb.exactRef("HEAD");
        if (head != null) {
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, head));
        }
        for (Ref r : refdb.getRefs()) {
            if (r.getName().equals(this.txnCommitted) || r.getName().equals("HEAD") || r.getName().startsWith(this.txnNamespace)) continue;
            cmds.add(new org.eclipse.jgit.internal.storage.reftree.Command(null, this.db.getRefDatabase().peel(r)));
        }
        tree.apply(cmds);
        return tree;
    }
}

