/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Option;

@Command(usage="usage_ShowDirCache")
class ShowDirCache
extends TextBuiltin {
    @Option(name="--millis", aliases={"-m"}, usage="usage_showTimeInMilliseconds")
    private boolean millis = false;

    ShowDirCache() {
    }

    @Override
    protected void run() throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss.SSS");
        DirCache cache = this.db.readDirCache();
        int i = 0;
        while (i < cache.getEntryCount()) {
            DirCacheEntry ent = cache.getEntry(i);
            FileMode mode = FileMode.fromBits(ent.getRawMode());
            int len = ent.getLength();
            long lastModified = ent.getLastModified();
            Date mtime = new Date(lastModified);
            int stage = ent.getStage();
            this.outw.print(mode);
            this.outw.format(" %6d", len);
            this.outw.print(' ');
            if (this.millis) {
                this.outw.print(lastModified);
            } else {
                this.outw.print(fmt.format(mtime));
            }
            this.outw.print(' ');
            this.outw.print(ent.getObjectId().name());
            this.outw.print(' ');
            this.outw.print(stage);
            this.outw.print('\t');
            this.outw.print(ent.getPathString());
            this.outw.println();
            ++i;
        }
    }
}

