/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command
class WriteReftable
extends TextBuiltin {
    private static final int KIB = 1024;
    private static final int MIB = 0x100000;
    @Option(name="--block-size")
    private int refBlockSize;
    @Option(name="--log-block-size")
    private int logBlockSize;
    @Option(name="--restart-interval")
    private int restartInterval;
    @Option(name="--index-levels")
    private int indexLevels;
    @Option(name="--reflog-in")
    private String reflogIn;
    @Option(name="--no-index-objects")
    private boolean noIndexObjects;
    @Argument(index=0)
    private String in;
    @Argument(index=1)
    private String out;

    WriteReftable() {
    }

    @Override
    protected void run() throws Exception {
        ReftableWriter.Stats stats;
        List<Ref> refs = WriteReftable.readRefs(this.in);
        List<LogEntry> logs = WriteReftable.readLog(this.reflogIn);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream os = new FileOutputStream(this.out);){
            ReftableConfig cfg = new ReftableConfig();
            cfg.setIndexObjects(!this.noIndexObjects);
            if (this.refBlockSize > 0) {
                cfg.setRefBlockSize(this.refBlockSize);
            }
            if (this.logBlockSize > 0) {
                cfg.setLogBlockSize(this.logBlockSize);
            }
            if (this.restartInterval > 0) {
                cfg.setRestartInterval(this.restartInterval);
            }
            if (this.indexLevels > 0) {
                cfg.setMaxIndexLevels(this.indexLevels);
            }
            ReftableWriter w = new ReftableWriter(cfg);
            w.setMinUpdateIndex(WriteReftable.min(logs)).setMaxUpdateIndex(WriteReftable.max(logs));
            w.begin(os);
            w.sortAndWriteRefs(refs);
            for (LogEntry e : logs) {
                w.writeLog(e.ref, e.updateIndex, e.who, e.oldId, e.newId, e.message);
            }
            stats = w.finish().getStats();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        double fileMiB = (double)stats.totalBytes() / 1048576.0;
        this.printf("Summary:", new Object[0]);
        this.printf("  file sz : %.1f MiB (%d bytes)", fileMiB, stats.totalBytes());
        this.printf("  padding : %d KiB", stats.paddingBytes() / 1024L);
        this.errw.println();
        this.printf("Refs:", new Object[0]);
        this.printf("  ref blk : %d", stats.refBlockSize());
        this.printf("  restarts: %d", stats.restartInterval());
        this.printf("  refs    : %d", stats.refCount());
        if (stats.refIndexLevels() > 0) {
            int idxSize = (int)Math.round((double)stats.refIndexSize() / 1024.0);
            this.printf("  idx sz  : %d KiB", idxSize);
            this.printf("  idx lvl : %d", stats.refIndexLevels());
        }
        this.printf("  avg ref : %d bytes", stats.refBytes() / (long)refs.size());
        this.errw.println();
        if (stats.objCount() > 0L) {
            int objMiB = (int)Math.round((double)stats.objBytes() / 1048576.0);
            int idLen = stats.objIdLength();
            this.printf("Objects:", new Object[0]);
            this.printf("  obj blk : %d", stats.refBlockSize());
            this.printf("  restarts: %d", stats.restartInterval());
            this.printf("  objects : %d", stats.objCount());
            this.printf("  obj sz  : %d MiB (%d bytes)", objMiB, stats.objBytes());
            if (stats.objIndexSize() > 0) {
                int s = (int)Math.round((double)stats.objIndexSize() / 1024.0);
                this.printf("  idx sz  : %d KiB", s);
                this.printf("  idx lvl : %d", stats.objIndexLevels());
            }
            this.printf("  id len  : %d bytes (%d hex digits)", idLen, 2 * idLen);
            this.printf("  avg obj : %d bytes", stats.objBytes() / stats.objCount());
            this.errw.println();
        }
        if (stats.logCount() > 0L) {
            int logMiB = (int)Math.round((double)stats.logBytes() / 1048576.0);
            this.printf("Log:", new Object[0]);
            this.printf("  log blk : %d", stats.logBlockSize());
            this.printf("  logs    : %d", stats.logCount());
            this.printf("  log sz  : %d MiB (%d bytes)", logMiB, stats.logBytes());
            this.printf("  avg log : %d bytes", stats.logBytes() / (long)logs.size());
            this.errw.println();
        }
    }

    private void printf(String fmt, Object ... args) throws IOException {
        this.errw.println(String.format(fmt, args));
    }

    static List<Ref> readRefs(String inputFile) throws IOException {
        ArrayList<Ref> refs = new ArrayList<Ref>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                ObjectId id = ObjectId.fromString(line.substring(0, 40));
                String name = line.substring(41, line.length());
                if (name.endsWith("^{}")) {
                    int lastIdx = refs.size() - 1;
                    Ref last = (Ref)refs.get(lastIdx);
                    refs.set(lastIdx, new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id));
                    continue;
                }
                Ref ref = name.equals("HEAD") ? new SymbolicRef(name, new ObjectIdRef.Unpeeled(Ref.Storage.NEW, "refs/heads/master", null)) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id);
                refs.add(ref);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collections.sort(refs, (a, b) -> a.getName().compareTo(b.getName()));
        return refs;
    }

    private static List<LogEntry> readLog(String logPath) throws FileNotFoundException, IOException {
        if (logPath == null) {
            return Collections.emptyList();
        }
        ArrayList<LogEntry> log = new ArrayList<LogEntry>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logPath), StandardCharsets.UTF_8));){
            String line;
            Pattern pattern = Pattern.compile("([^,]+),([0-9]+(?:[.][0-9]+)?),([^,]+),([^,]+),([^,]+),(.*)");
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line);
                if (!m.matches()) {
                    throw new IOException("unparsed line: " + line);
                }
                String ref = m.group(1);
                double t = Double.parseDouble(m.group(2));
                long time = (long)t * 1000L;
                long index = (long)(t * 1000000.0);
                String user = m.group(3);
                ObjectId oldId = WriteReftable.parseId(m.group(4));
                ObjectId newId = WriteReftable.parseId(m.group(5));
                String msg = m.group(6);
                String email = String.valueOf(user) + "@gerrit";
                PersonIdent who = new PersonIdent(user, email, time, -480);
                log.add(new LogEntry(ref, index, who, oldId, newId, msg));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Collections.sort(log, LogEntry::compare);
        return log;
    }

    private static long min(List<LogEntry> log) {
        return log.stream().mapToLong(e -> e.updateIndex).min().orElse(0L);
    }

    private static long max(List<LogEntry> log) {
        return log.stream().mapToLong(e -> e.updateIndex).max().orElse(0L);
    }

    private static ObjectId parseId(String s) {
        if ("NULL".equals(s)) {
            return ObjectId.zeroId();
        }
        return ObjectId.fromString(s);
    }

    private static class LogEntry {
        final String ref;
        final long updateIndex;
        final PersonIdent who;
        final ObjectId oldId;
        final ObjectId newId;
        final String message;

        static int compare(LogEntry a, LogEntry b) {
            int cmp = a.ref.compareTo(b.ref);
            if (cmp == 0) {
                cmp = Long.signum(b.updateIndex - a.updateIndex);
            }
            return cmp;
        }

        LogEntry(String ref, long updateIndex, PersonIdent who, ObjectId oldId, ObjectId newId, String message) {
            this.ref = ref;
            this.updateIndex = updateIndex;
            this.who = who;
            this.oldId = oldId;
            this.newId = newId;
            this.message = message;
        }
    }
}

