/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.TemporaryBufferEntity;
import org.eclipse.jgit.transport.http.apache.internal.HttpApacheText;
import org.eclipse.jgit.util.TemporaryBuffer;

public class HttpClientConnection
implements HttpConnection {
    HttpClient client;
    URL url;
    HttpUriRequest req;
    HttpResponse resp = null;
    String method = "GET";
    private TemporaryBufferEntity entity;
    private boolean isUsingProxy = false;
    private Proxy proxy;
    private Integer timeout = null;
    private Integer readTimeout;
    private Boolean followRedirects;
    private HostnameVerifier hostnameverifier;
    SSLContext ctx;

    private HttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder clientBuilder = HttpClients.custom();
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            if (this.proxy != null && !Proxy.NO_PROXY.equals(this.proxy)) {
                this.isUsingProxy = true;
                InetSocketAddress adr = (InetSocketAddress)this.proxy.address();
                clientBuilder.setProxy(new HttpHost(adr.getHostName(), adr.getPort()));
            }
            if (this.timeout != null) {
                configBuilder.setConnectTimeout(this.timeout);
            }
            if (this.readTimeout != null) {
                configBuilder.setSocketTimeout(this.readTimeout);
            }
            if (this.followRedirects != null) {
                configBuilder.setRedirectsEnabled(this.followRedirects);
            }
            if (this.hostnameverifier != null) {
                SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(this.getSSLContext(), this.hostnameverifier);
                clientBuilder.setSSLSocketFactory(sslConnectionFactory);
                Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslConnectionFactory).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
                clientBuilder.setConnectionManager(new BasicHttpClientConnectionManager(registry));
            }
            clientBuilder.setDefaultRequestConfig(configBuilder.build());
            this.client = clientBuilder.build();
        }
        return this.client;
    }

    private SSLContext getSSLContext() {
        if (this.ctx == null) {
            try {
                this.ctx = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(HttpApacheText.get().unexpectedSSLContextException, e);
            }
        }
        return this.ctx;
    }

    public void setBuffer(TemporaryBuffer buffer) {
        this.entity = new TemporaryBufferEntity(buffer);
    }

    public HttpClientConnection(String urlStr) throws MalformedURLException {
        this(urlStr, null);
    }

    public HttpClientConnection(String urlStr, Proxy proxy) throws MalformedURLException {
        this(urlStr, proxy, null);
    }

    public HttpClientConnection(String urlStr, Proxy proxy, HttpClient cl) throws MalformedURLException {
        this.client = cl;
        this.url = new URL(urlStr);
        this.proxy = proxy;
    }

    @Override
    public int getResponseCode() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getStatusCode();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getResponseMessage() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getReasonPhrase();
    }

    private void execute() throws IOException, ClientProtocolException {
        if (this.resp != null) {
            return;
        }
        if (this.entity == null) {
            this.resp = this.getClient().execute(this.req);
            return;
        }
        try {
            if (this.req instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest eReq = (HttpEntityEnclosingRequest)((Object)this.req);
                eReq.setEntity(this.entity);
            }
            this.resp = this.getClient().execute(this.req);
        }
        finally {
            this.entity.close();
            this.entity = null;
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        Header[] headerArray = this.resp.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header hdr = headerArray[n2];
            LinkedList<String> list = (LinkedList<String>)ret.get(hdr.getName());
            if (list == null) {
                list = new LinkedList<String>();
                ret.put(hdr.getName(), list);
            }
            HeaderElement[] headerElementArray = hdr.getElements();
            int n3 = headerElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                HeaderElement hdrElem = headerElementArray[n4];
                list.add(hdrElem.toString());
                ++n4;
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public void setRequestProperty(String name, String value) {
        this.req.addHeader(name, value);
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.method = method;
        if ("GET".equalsIgnoreCase(method)) {
            this.req = new HttpGet(this.url.toString());
        } else if ("HEAD".equalsIgnoreCase(method)) {
            this.req = new HttpHead(this.url.toString());
        } else if ("PUT".equalsIgnoreCase(method)) {
            this.req = new HttpPut(this.url.toString());
        } else if ("POST".equalsIgnoreCase(method)) {
            this.req = new HttpPost(this.url.toString());
        } else {
            this.method = null;
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setUseCaches(boolean usecaches) {
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public String getContentType() {
        Header contentType;
        HttpEntity responseEntity = this.resp.getEntity();
        if (responseEntity != null && (contentType = responseEntity.getContentType()) != null) {
            return contentType.getValue();
        }
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.resp.getEntity().getContent();
    }

    @Override
    public String getHeaderField(String name) {
        Header header = this.resp.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public int getContentLength() {
        Header contentLength = this.resp.getFirstHeader("content-length");
        if (contentLength == null) {
            return -1;
        }
        try {
            int l = Integer.parseInt(contentLength.getValue());
            return l < 0 ? -1 : l;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    @Override
    public void setDoOutput(boolean dooutput) {
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.entity != null) {
            throw new IllegalArgumentException();
        }
        this.entity = new TemporaryBufferEntity(new TemporaryBuffer.LocalFile(null));
        this.entity.setContentLength(contentLength);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity(new TemporaryBuffer.LocalFile(null));
        }
        return this.entity.getBuffer();
    }

    @Override
    public void setChunkedStreamingMode(int chunklen) {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity(new TemporaryBuffer.LocalFile(null));
        }
        this.entity.setChunked(true);
    }

    @Override
    public String getRequestMethod() {
        return this.method;
    }

    @Override
    public boolean usingProxy() {
        return this.isUsingProxy;
    }

    @Override
    public void connect() throws IOException {
        this.execute();
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameverifier) {
        this.hostnameverifier = hostnameverifier;
    }

    @Override
    public void configure(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws KeyManagementException {
        this.getSSLContext().init(km, tm, random);
    }
}

