/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.eclipse.jgit.util.TemporaryBuffer;

public class TemporaryBufferEntity
extends AbstractHttpEntity
implements AutoCloseable {
    private TemporaryBuffer buffer;
    private Integer contentLength;

    public TemporaryBufferEntity(TemporaryBuffer buffer) {
        this.buffer = buffer;
    }

    public TemporaryBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        if (this.contentLength != null) {
            return this.contentLength.intValue();
        }
        return this.buffer.length();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.buffer.openInputStream();
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        this.buffer.writeTo(outstream, null);
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.destroy();
        }
    }
}

