/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;

public class RebaseTodoLine {
    Action action;
    final AbbreviatedObjectId commit;
    String shortMessage;
    String comment;

    public RebaseTodoLine(String newComment) {
        this.action = Action.COMMENT;
        this.setComment(newComment);
        this.commit = null;
        this.shortMessage = null;
    }

    public RebaseTodoLine(Action action, AbbreviatedObjectId commit, String shortMessage) {
        this.action = action;
        this.commit = commit;
        this.shortMessage = shortMessage;
        this.comment = null;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action newAction) {
        if (!Action.COMMENT.equals((Object)this.action) && Action.COMMENT.equals((Object)newAction)) {
            if (this.comment == null) {
                this.comment = "# " + this.action.token + " " + (this.commit == null ? "null" : this.commit.name()) + " " + (this.shortMessage == null ? "null" : this.shortMessage);
            }
        } else if (Action.COMMENT.equals((Object)this.action) && !Action.COMMENT.equals((Object)newAction) && this.commit == null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotChangeActionOnComment, new Object[]{this.action, newAction}));
        }
        this.action = newAction;
    }

    public void setComment(String newComment) {
        if (newComment == null) {
            this.comment = null;
            return;
        }
        if (newComment.contains("\n") || newComment.contains("\r")) {
            throw RebaseTodoLine.createInvalidCommentException(newComment);
        }
        if (newComment.trim().length() == 0 || newComment.startsWith("#")) {
            this.comment = newComment;
            return;
        }
        throw RebaseTodoLine.createInvalidCommentException(newComment);
    }

    private static JGitInternalException createInvalidCommentException(String newComment) {
        IllegalArgumentException iae = new IllegalArgumentException(MessageFormat.format(JGitText.get().argumentIsNotAValidCommentString, newComment));
        return new JGitInternalException(iae.getMessage(), iae);
    }

    public AbbreviatedObjectId getCommit() {
        return this.commit;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Step[" + (Object)((Object)this.action) + ", " + (this.commit == null ? "null" : this.commit) + ", " + (this.shortMessage == null ? "null" : this.shortMessage) + ", " + (this.comment == null ? "" : this.comment) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        PICK("pick", "p"),
        REWORD("reword", "r"),
        EDIT("edit", "e"),
        SQUASH("squash", "s"),
        FIXUP("fixup", "f"),
        COMMENT("comment", "#");

        private final String token;
        private final String shortToken;

        private Action(String token, String shortToken) {
            this.token = token;
            this.shortToken = shortToken;
        }

        public String toToken() {
            return this.token;
        }

        public String toString() {
            return "Action[" + this.token + "]";
        }

        public static Action parse(String token) {
            for (Action action : Action.values()) {
                if (!action.token.equals(token) && !action.shortToken.equals(token)) continue;
                return action;
            }
            throw new JGitInternalException(MessageFormat.format(JGitText.get().unknownOrUnsupportedCommand, new Object[]{token, Action.values()}));
        }
    }
}

