/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.RawParseUtils;

public class ObjectId
extends AnyObjectId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectId ZEROID = new ObjectId(0, 0, 0, 0, 0);
    private static final String ZEROID_STR = ZEROID.name();

    public static final ObjectId zeroId() {
        return ZEROID;
    }

    public static final boolean isId(String id) {
        if (id.length() != 40) {
            return false;
        }
        try {
            for (int i = 0; i < 40; ++i) {
                RawParseUtils.parseHexInt4((byte)id.charAt(i));
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static final String toString(ObjectId i) {
        return i != null ? i.name() : ZEROID_STR;
    }

    public static boolean equals(byte[] firstBuffer, int fi, byte[] secondBuffer, int si) {
        return firstBuffer[fi] == secondBuffer[si] && firstBuffer[fi + 1] == secondBuffer[si + 1] && firstBuffer[fi + 2] == secondBuffer[si + 2] && firstBuffer[fi + 3] == secondBuffer[si + 3] && firstBuffer[fi + 4] == secondBuffer[si + 4] && firstBuffer[fi + 5] == secondBuffer[si + 5] && firstBuffer[fi + 6] == secondBuffer[si + 6] && firstBuffer[fi + 7] == secondBuffer[si + 7] && firstBuffer[fi + 8] == secondBuffer[si + 8] && firstBuffer[fi + 9] == secondBuffer[si + 9] && firstBuffer[fi + 10] == secondBuffer[si + 10] && firstBuffer[fi + 11] == secondBuffer[si + 11] && firstBuffer[fi + 12] == secondBuffer[si + 12] && firstBuffer[fi + 13] == secondBuffer[si + 13] && firstBuffer[fi + 14] == secondBuffer[si + 14] && firstBuffer[fi + 15] == secondBuffer[si + 15] && firstBuffer[fi + 16] == secondBuffer[si + 16] && firstBuffer[fi + 17] == secondBuffer[si + 17] && firstBuffer[fi + 18] == secondBuffer[si + 18] && firstBuffer[fi + 19] == secondBuffer[si + 19];
    }

    public static final ObjectId fromRaw(byte[] bs) {
        return ObjectId.fromRaw(bs, 0);
    }

    public static final ObjectId fromRaw(byte[] bs, int p) {
        int a = NB.decodeInt32(bs, p);
        int b = NB.decodeInt32(bs, p + 4);
        int c = NB.decodeInt32(bs, p + 8);
        int d = NB.decodeInt32(bs, p + 12);
        int e = NB.decodeInt32(bs, p + 16);
        return new ObjectId(a, b, c, d, e);
    }

    public static final ObjectId fromRaw(int[] is) {
        return ObjectId.fromRaw(is, 0);
    }

    public static final ObjectId fromRaw(int[] is, int p) {
        return new ObjectId(is[p], is[p + 1], is[p + 2], is[p + 3], is[p + 4]);
    }

    public static final ObjectId fromString(byte[] buf, int offset) {
        return ObjectId.fromHexString(buf, offset);
    }

    public static ObjectId fromString(String str) {
        if (str.length() != 40) {
            throw new IllegalArgumentException("Invalid id: " + str);
        }
        return ObjectId.fromHexString(Constants.encodeASCII(str), 0);
    }

    private static final ObjectId fromHexString(byte[] bs, int p) {
        try {
            int a = RawParseUtils.parseHexInt32(bs, p);
            int b = RawParseUtils.parseHexInt32(bs, p + 8);
            int c = RawParseUtils.parseHexInt32(bs, p + 16);
            int d = RawParseUtils.parseHexInt32(bs, p + 24);
            int e = RawParseUtils.parseHexInt32(bs, p + 32);
            return new ObjectId(a, b, c, d, e);
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new InvalidObjectIdException(bs, p, 40);
        }
    }

    ObjectId(int new_1, int new_2, int new_3, int new_4, int new_5) {
        this.w1 = new_1;
        this.w2 = new_2;
        this.w3 = new_3;
        this.w4 = new_4;
        this.w5 = new_5;
    }

    protected ObjectId(AnyObjectId src) {
        this.w1 = src.w1;
        this.w2 = src.w2;
        this.w3 = src.w3;
        this.w4 = src.w4;
        this.w5 = src.w5;
    }

    @Override
    public ObjectId toObjectId() {
        return this;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeInt(this.w1);
        os.writeInt(this.w2);
        os.writeInt(this.w3);
        os.writeInt(this.w4);
        os.writeInt(this.w5);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        this.w1 = ois.readInt();
        this.w2 = ois.readInt();
        this.w3 = ois.readInt();
        this.w4 = ois.readInt();
        this.w5 = ois.readInt();
    }
}

